/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.imports.vtml.AggregationDefinition;
import org.eclipse.viatra2.imports.vtml.AnySourceDefinition;
import org.eclipse.viatra2.imports.vtml.AnyTargetDefinition;
import org.eclipse.viatra2.imports.vtml.ElementDefinition;
import org.eclipse.viatra2.imports.vtml.EntityDefinition;
import org.eclipse.viatra2.imports.vtml.FinalTypeDefinition;
import org.eclipse.viatra2.imports.vtml.InverseDefinition;
import org.eclipse.viatra2.imports.vtml.MultiplicityDefinition;
import org.eclipse.viatra2.imports.vtml.NamespaceImport;
import org.eclipse.viatra2.imports.vtml.RelationDefinition;
import org.eclipse.viatra2.imports.vtml.RelationshipDefinition;
import org.eclipse.viatra2.imports.vtml.SupertypeDefinition;
import org.eclipse.viatra2.imports.vtml.TypeDefinition;
import org.eclipse.viatra2.imports.vtml.VTMLMetaModelHelper;
import org.eclipse.viatra2.logger.Logger;

public class ASTBuilder {
    Vector imps;
    String namespac = null;
    public Logger log;
    Vector machines;
    IEntity ent;
    Vector reldefs;
    IModelSpace ms;
    HashSet<EntityDefinition> entities = null;
    HashSet<EntityDefinition> entity_tmp = null;
    HashSet<RelationDefinition> relation_tmp = null;
    IModelManager mm = null;
    int nameID = 1;

    public String getNamespace() {
        return this.namespac;
    }

    public void init(Logger l, IModelSpace m) {
        this.ms = m;
        this.imps = new Vector();
        this.entities = new HashSet();
        this.entity_tmp = new HashSet();
        this.relation_tmp = new HashSet();
        this.reldefs = new Vector();
        this.machines = new Vector();
        this.namespac = "";
        this.mm = m.getModelManager();
        this.log = l;
        try {
            VTMLMetaModelHelper.init(l, m, this);
        }
        catch (Exception e) {
            this.log.fatal("VTML Importer initialization failed. All further imports will fail. Cause : " + e.getLocalizedMessage());
        }
    }

    public void addSupertypeDefinition(int l, String ns, String m, String s) {
        this.reldefs.add(new SupertypeDefinition(l, ns, m, s));
    }

    public void addTypeDefinition(int l, String ns, String m, String s) {
        this.reldefs.add(new TypeDefinition(l, ns, m, s));
    }

    public void addIsFinalTypeDefinition(int l, String ns, String n, boolean b) {
        this.reldefs.add(new FinalTypeDefinition(l, ns, n, b));
    }

    public void addIsAggregationDefinition(int l, String ns, String n, boolean b) {
        this.reldefs.add(new AggregationDefinition(l, ns, n, b));
    }

    public void addIsAnySourceDefinition(int l, String ns, String n, boolean b) {
        this.reldefs.add(new AnySourceDefinition(l, ns, n, b));
    }

    public void addIsAnyTargetDefinition(int l, String ns, String n, boolean b) {
        this.reldefs.add(new AnyTargetDefinition(l, ns, n, b));
    }

    public void addInverseDefinition(int l, String ns, String n, String i) {
        this.reldefs.add(new InverseDefinition(l, ns, n, i));
    }

    public void addMultiplicityDefinition(int l, String ns, String n, String i) {
        this.reldefs.add(new MultiplicityDefinition(l, ns, n, i));
    }

    public IEntity lookupNamespace(String ns) {
        IEntity e = null;
        if (ns.equals("")) {
            return this.mm.getRoot();
        }
        e = this.mm.getEntityByName(ns);
        if (e != null) {
            return e;
        }
        int i = 0;
        while (i < this.imps.size()) {
            NamespaceImport ni = (NamespaceImport)this.imps.get(i);
            e = this.mm.getEntityByName(String.valueOf(ni.getName()) + "." + ns);
            if (e != null) {
                return e;
            }
            ++i;
        }
        return null;
    }

    private boolean preamb(String n, String e) {
        return n.startsWith(e) && n.length() > e.length() && n.charAt(e.length()) == '.';
    }

    private EntityDefinition getEntityByQN(String n, HashSet<EntityDefinition> hs) {
        for (EntityDefinition e : hs) {
            if (n.equals(e.getFQN())) {
                return e;
            }
            if (!this.preamb(n, e.getFQN())) continue;
            return this.getEntityByQN(n, e.getContent());
        }
        return null;
    }

    public EntityDefinition lookupDuplicateEntity(EntityDefinition ed) {
        return this.getEntityByQN(ed.getFQN(), this.entities, ed);
    }

    private EntityDefinition getEntityByQN(String n, HashSet<EntityDefinition> hs, EntityDefinition self) {
        for (EntityDefinition e : hs) {
            if (n.equals(e.getFQN()) && e != self) {
                return e;
            }
            if (!this.preamb(n, e.getFQN())) continue;
            return this.getEntityByQN(n, e.getContent(), self);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public EntityDefinition getEntityWithLookup(String ns, String n) {
        this.log.debug("called entityWithlookup: " + ns + " name: " + n);
        this.log.debug("lookup ns: " + ns + " name: " + n);
        ed = null;
        if (n == null) {
            return null;
        }
        if (n.indexOf(46) < 0) ** GOTO lbl15
        ed = this.getEntityByQN(n, this.entities);
        this.log.debug("lookup: " + n + " res: " + ed);
        if (ed == null) ** GOTO lbl15
        return ed;
lbl-1000:
        // 1 sources

        {
            ed = this.getEntityByQN(this.fqn(ns, n), this.entities);
            if (ed != null) {
                return ed;
            }
            ns = this.parentName(ns);
lbl15:
            // 3 sources

            ** while (ed == null && ns != null)
        }
lbl16:
        // 1 sources

        ee = this.mm.getEntityByName(this.fqn(ns, n));
        if (ee != null) {
            ed = new EntityDefinition(ee);
            try {
                this.buildEntityTree(ed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ed;
        }
        i = 0;
        while (i < this.imps.size()) {
            ni = (NamespaceImport)this.imps.get(i);
            this.log.debug("lookup import: " + ni.getName() + " name: " + n);
            e = this.mm.getEntityByName(String.valueOf(ni.getName()) + "." + n);
            if (e != null) {
                ed = new EntityDefinition(e);
                try {
                    this.buildEntityTree(ed);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                return ed;
            }
            ++i;
        }
        return null;
    }

    public ElementDefinition getElementWithLookup(String ns, String n) {
        EntityDefinition ed = this.getEntityWithLookup(ns, n);
        if (ed != null) {
            return ed;
        }
        return this.getRelationWithLookup(ns, n);
    }

    public RelationDefinition getRelationWithLookup(String ns, String n) {
        ElementDefinition ted;
        RelationDefinition ed = null;
        if (n.indexOf(46) >= 0 && (ted = this.getElementByQN(n, this.entities)) != null && ted instanceof RelationDefinition) {
            return (RelationDefinition)ted;
        }
        String nstmp = ns;
        while (ed == null && nstmp != null) {
            ElementDefinition ted2 = this.getElementByQN(this.fqn(nstmp, n), this.entities);
            if (ted2 != null && ted2 instanceof RelationDefinition) {
                return (RelationDefinition)ted2;
            }
            nstmp = this.parentName(nstmp);
        }
        IRelation ee = this.mm.getRelationByName(this.fqn(ns, n));
        if (ee != null) {
            ed = new RelationDefinition(ee);
            try {
                this.addRelationToTree(ed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ed;
        }
        ee = this.mm.getRelationByName(n);
        if (ee != null) {
            ed = new RelationDefinition(ee);
            try {
                this.addRelationToTree(ed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ed;
        }
        int i = 0;
        while (i < this.imps.size()) {
            NamespaceImport ni = (NamespaceImport)this.imps.get(i);
            IRelation e = this.mm.getRelationByName(String.valueOf(ni.getName()) + "." + n);
            if (e != null) {
                ed = new RelationDefinition(e);
                try {
                    this.addRelationToTree(ed);
                }
                catch (Exception exception) {}
                return ed;
            }
            ++i;
        }
        return null;
    }

    private RelationDefinition getRelationByQN(String n, HashSet<RelationDefinition> hs) {
        for (RelationDefinition e : hs) {
            if (n.equals(e.getFQN())) {
                return e;
            }
            if (!this.preamb(n, e.getFQN())) continue;
            return this.getRelationByQN(n, e.getRelations());
        }
        return null;
    }

    private ElementDefinition getElementByQN(String n, HashSet<EntityDefinition> hs) {
        for (EntityDefinition e : hs) {
            if (n.equals(e.getFQN())) {
                return e;
            }
            if (!n.startsWith(e.getFQN())) continue;
            ElementDefinition ed = this.getElementByQN(n, e.getContent());
            if (ed == null) {
                for (RelationDefinition r : e.relations) {
                    RelationDefinition rtmp;
                    if (r.getFQN().equals(n)) {
                        return r;
                    }
                    if (!r.getFQN().startsWith(n) || (rtmp = this.getRelationByQN(n, r.getRelations())) == null) continue;
                    return rtmp;
                }
                continue;
            }
            return ed;
        }
        return null;
    }

    public boolean namespaceExists(String ns) {
        if (ns.equals("")) {
            return true;
        }
        if (this.lookupNamespace(ns) != null) {
            return true;
        }
        return this.getEntityByQN(ns, this.entities) != null;
    }

    public String fqn(String ns, String n) {
        if (ns == null) {
            return n;
        }
        if (ns.length() == 0) {
            return n;
        }
        return String.valueOf(ns) + "." + n;
    }

    public void addEntityDef(int l, String ns, String n, String t, String v) {
        this.entity_tmp.add(new EntityDefinition(l, ns, n, t, v));
    }

    public void addRelationDef(int l, String ns, String n, String t, String s, String ta) {
        RelationDefinition rd = new RelationDefinition(l, ns, n, t, s, ta);
        this.relation_tmp.add(rd);
    }

    public void addImport(int l, String s) {
        this.imps.add(new NamespaceImport(l, s));
    }

    public void setNamespace(String s) {
        this.namespac = s;
    }

    public void debug() {
        this.log.debug("Module namespace : " + this.namespac);
        this.log.debug("\nimports:");
        this.printEntities(this.entities, 0);
        int i = 0;
        while (i < this.imps.size()) {
            this.log.debug("     " + ((NamespaceImport)this.imps.get(i)).getName());
            ++i;
        }
    }

    public void printEntities(HashSet<EntityDefinition> e, int i) {
        for (EntityDefinition ed : e) {
            this.log.debug(String.valueOf("                                                                                                                    ".substring(0, i)) + ed.getFQN());
            this.printEntities(ed.getContent(), i + 2);
        }
    }

    public String parentName(String fqn) {
        if (fqn == null) {
            return null;
        }
        if (fqn.equals("")) {
            return null;
        }
        int i = fqn.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return fqn.substring(0, i);
    }

    public EntityDefinition getFromTmp(String _fqn) {
        for (EntityDefinition e : this.entity_tmp) {
            if (!_fqn.equals(this.fqn(e.getNamespace(), e.getName()))) continue;
            return e;
        }
        return null;
    }

    public void buildEntityTree(EntityDefinition ed) throws VPMRuntimeException {
        String ns = ed.getNamespace();
        String n = ed.getName();
        String fqn = this.fqn(ns, n);
        ed.setProcessed(true);
        if (this.mm.getEntityByName(fqn) != null && !ed.isNative) {
            this.log.error("duplicate entity found! (" + fqn + ") error in line " + ed.getLine());
            throw new VPMRuntimeException("duplicate entity found! (" + fqn + ") error in line " + ed.getLine());
        }
        EntityDefinition etmp = this.getEntityByQN(fqn, this.entities);
        if (!(etmp == null || ed == etmp || ed.isNative && etmp.isNative)) {
            this.log.error("duplicate entity found! (" + fqn + ") error in line " + ed.getLine());
            throw new VPMRuntimeException("duplicate entity found! (" + fqn + ") error in line " + ed.getLine());
        }
        if (etmp != null) {
            return;
        }
        String par = this.parentName(fqn);
        if (par == null || par.equals("")) {
            this.entities.add(ed);
            return;
        }
        EntityDefinition ep = this.getFromTmp(par);
        if (ep == null) {
            ep = this.getEntityByQN(par, this.entities);
        }
        if (ep == null) {
            IEntity ee = this.mm.getEntityByName(par);
            if (ee == null) {
                this.log.error("parent entity " + par + " for entity " + fqn + " is undefined.");
                throw new VPMRuntimeException("entity undefined: " + fqn);
            }
            ep = new EntityDefinition(ee);
            this.buildEntityTree(ep);
        }
        ep.addContent(ed);
    }

    public String localName(String s) {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    private void addRelationToTree(RelationDefinition d) throws VPMRuntimeException {
        String ns = d.getNamespace();
        String n = d.getName();
        String en = d.getSource();
        String sfqn = this.fqn(ns, en);
        String tmpns = ns;
        String realFqn = this.fqn(sfqn, this.localName(n));
        ElementDefinition ed = null;
        d.setProcessed(true);
        ed = this.getElementByQN(this.fqn(ns, n), this.entities);
        if (this.mm.getRelationByName(realFqn) != null && !d.isNativ) {
            this.log.error("Duplicate relation (" + this.fqn(ns, n) + ") found. Error in line " + d.getLine());
        }
        if (ed != null && ed != d) {
            this.log.error("Duplicate relation (" + ed.getFQN() + ") found. Error in line " + d.getLine());
        }
        while (ed == null && tmpns != null) {
            ed = this.getElementByQN(this.fqn(tmpns, en), this.entities);
            tmpns = this.parentName(tmpns);
        }
        if (ed == null) {
            for (RelationDefinition rr : this.relation_tmp) {
                if (rr.isProcessed() || !rr.getName().equals(this.localName(en))) continue;
                this.addRelationToTree(rr);
                ed = this.getElementByQN(en, this.entities);
                if (ed != null) break;
            }
            if (ed == null && (ed = this.getElementWithLookup(ns, en)) == null) {
                this.log.error("Source (" + sfqn + ") for relation " + n + " undefined.");
                throw new VPMRuntimeException("error. relation source undefined.");
            }
        }
        ed.addRelation(d);
    }

    public boolean checkDefinition() {
        if (this.mm.getEntityByName(this.namespac) == null) {
            this.log.error("Namespace " + this.namespac + " not found. Invalid namespace reference.");
            return false;
        }
        int i = 0;
        while (i < this.imps.size()) {
            NamespaceImport ni = (NamespaceImport)this.imps.get(i);
            if (!ni.checkDefintion(this, this.ms)) {
                return false;
            }
            ++i;
        }
        for (EntityDefinition e : this.entity_tmp) {
            e.normalizeName(this);
        }
        for (EntityDefinition e : this.entity_tmp) {
            try {
                if (e.isProcessed()) continue;
                this.buildEntityTree(e);
            }
            catch (VPMRuntimeException vPMRuntimeException) {
                return false;
            }
        }
        for (RelationDefinition r : this.relation_tmp) {
            try {
                if (r.isProcessed()) continue;
                this.addRelationToTree(r);
            }
            catch (VPMRuntimeException vPMRuntimeException) {
                return false;
            }
        }
        Collection eetmp = (Collection)this.entities.clone();
        for (EntityDefinition e : eetmp) {
            if (e.checkDefintion(this, this.ms)) continue;
            return false;
        }
        int i2 = 0;
        while (i2 < this.reldefs.size()) {
            RelationshipDefinition ni;
            if (this.reldefs.get(i2) instanceof RelationshipDefinition && !(ni = (RelationshipDefinition)this.reldefs.get(i2)).checkDefintion(this, this.ms)) {
                return false;
            }
            ++i2;
        }
        this.log.debug("end " + this.mm.getElementByName("reldb"));
        return true;
    }

    public void generateElements() throws VPMCoreException {
        for (EntityDefinition e : this.entities) {
            e.updateModelspace(this, this.ms);
        }
        int i = 0;
        while (i < this.reldefs.size()) {
            if (this.reldefs.get(i) instanceof RelationshipDefinition) {
                RelationshipDefinition ni = (RelationshipDefinition)this.reldefs.get(i);
                ni.resolveReferences(this);
            }
            ++i;
        }
    }

    public String nameGenerator() {
        return "_tmp" + this.nameID++;
    }
}

