/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.loader;

import java.io.IOException;
import java.util.List;
import lpg.lpgjavaruntime.DiagnoseParser;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Module;
import org.eclipse.viatra2.lpgparser.Option;
import org.eclipse.viatra2.lpgparser.VTCLLexer;
import org.eclipse.viatra2.lpgparser.VTCLParser;
import org.eclipse.viatra2.lpgparser.VTCLParserprs;
import org.eclipse.viatra2.lpgparser.ast.ASTNode;
import org.eclipse.viatra2.lpgparser.modelbuilder.VTCLModelBuilder;
import org.eclipse.viatra2.lpgparser.modelbuilder.VTCLModelResolver;
import org.eclipse.viatra2.lpgparser.typechecker.VTCLTypeChecker;
import org.eclipse.viatra2.natives.ASMNativeFunction;

public class VTCLParseController {
    protected ASTNode fAst;
    protected VTCLParser fParser;
    protected VTCLModelResolver fModelResolver;
    protected VTCLModelBuilder fModelBuilder;
    protected VTCLTypeChecker fTypeChecker;
    protected VTCLLexer fLexer;
    protected Module fVtclModule;
    protected String fFileName;
    protected IFramework fFramework;
    protected List<ErrorInformation> errors;
    protected char[][] fKeywords;
    protected boolean[] fIsKeyword;

    public VTCLModelResolver getModelResolver() {
        return this.fModelResolver;
    }

    public VTCLModelBuilder getModelBuilder() {
        return this.fModelBuilder;
    }

    public VTCLTypeChecker getTypeChecker() {
        return this.fTypeChecker;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public VTCLParser getParser() {
        return this.fParser;
    }

    public VTCLLexer getLexer() {
        return this.fLexer;
    }

    public Module getModule() {
        return this.fVtclModule;
    }

    public Machine getMachine() {
        if (this.fVtclModule != null && this.fVtclModule.getMachine() != null) {
            return (Machine)this.fVtclModule.getMachine().get(0);
        }
        return null;
    }

    public ASTNode getCurrentAst() {
        return this.fAst;
    }

    public boolean hasErrors() {
        if (!this.errors.isEmpty()) {
            for (ErrorInformation error : this.errors) {
                if (error.getErrorSeverity().compareTo((Enum)ErrorInformation.ErrorSeverity.ERROR) != 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    public void initialize(String filename, IFramework framework) {
        this.fFileName = filename;
        this.fFramework = framework;
        if (this.errors != null) {
            this.errors.clear();
        }
        this.createLexerAndParser();
        if (this.fModelBuilder == null) {
            this.createModelBuilder();
        }
        this.fParser.clearParseErrorList();
        this.fModelResolver.clearAllReferenceErrors();
        this.fTypeChecker.clearAllTypeErrors();
    }

    private void createModelBuilder() {
        if (this.fFramework != null) {
            IModelSpace modelSpace = this.fFramework.getTopmodel();
            ASMNativeFunction[] asmNativeFunctions = this.fFramework.getNativeFunctionManager().getAllNativeFunctions();
            this.fModelBuilder = new VTCLModelBuilder(modelSpace, asmNativeFunctions);
            this.fModelBuilder.setFileName(this.fFileName);
            this.fModelResolver = this.fModelBuilder.getModelResolver();
            this.fTypeChecker = this.fModelBuilder.getTypeChecker();
        }
    }

    private void createLexerAndParser() {
        String[] args = new String[]{"-d", this.fFileName};
        try {
            Option option = new Option(args);
            option.readInputChars();
            this.fLexer = new VTCLLexer(option.getInputChars(), option.getFileName());
            this.fLexer.setTab(4);
            this.fParser = new VTCLParser((LexStream)this.fLexer);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void parseAndBuild() throws VPMRuntimeException {
        this.parse();
        if (this.fAst != null && !this.hasErrors()) {
            this.build();
        }
    }

    protected void build() {
        if (this.fAst != null) {
            this.fModelResolver.clearAllReferenceErrors();
            this.fTypeChecker.clearAllTypeErrors();
            Module vtclModule = (Module)this.fAst.accept(this.fModelBuilder);
            this.errors.addAll(this.fModelResolver.getAllReferenceErrorInfos());
            this.fVtclModule = vtclModule;
            if (!this.hasErrors()) {
                this.fTypeChecker.doTypeChecking();
                this.errors.addAll(this.fTypeChecker.getAllTypeErrorInfos());
            } else {
                this.fTypeChecker.initializeTypeChecker();
            }
        }
    }

    protected void parse() {
        try {
            this.fParser.clearParseErrorList();
            if (this.errors != null) {
                this.errors.clear();
            }
            this.fLexer.lexer(this.fParser);
            ASTNode ast = this.fParser.parser(100);
            int errorIndex = this.fParser.getTokens().size() - 1;
            if (this.fParser.getFirstRealToken(errorIndex) != errorIndex) {
                VTCLParserprs prsTable = new VTCLParserprs();
                DiagnoseParser diagnoseParser = new DiagnoseParser((TokenStream)this.fParser, (ParseTable)prsTable);
                diagnoseParser.diagnose();
            }
            if (ast != null) {
                this.fAst = ast;
            }
            this.errors = this.fParser.getAllErrorInfos();
            if (this.fKeywords == null) {
                this.initKeywords();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void parseOnly() throws VPMRuntimeException {
        this.parse();
    }

    private void initKeywords() {
        String[] tokenKindNames = this.fParser.getParseStream().orderedTerminalSymbols();
        this.fIsKeyword = new boolean[tokenKindNames.length];
        this.fKeywords = new char[tokenKindNames.length][];
        int[] keywordKinds = this.fLexer.getKeywordKinds();
        int i = 1;
        while (i < keywordKinds.length) {
            int index = this.fParser.getParseStream().mapKind(keywordKinds[i]);
            this.fIsKeyword[index] = true;
            this.fKeywords[index] = this.fParser.getParseStream().orderedTerminalSymbols()[index].toCharArray();
            ++i;
        }
    }
}

