--
-- The VTCL Lexer
-- Copyright (c) 2007 OptXware Research and Development LLC.
-- All rights reserved.   This program and the accompanying materials
-- are made available under the terms of the Eclipse Public License v1.0
-- which accompanies this distribution, and is available at
-- http://www.eclipse.org/legal/epl-v10.html
--
-- Contributors:
--   Daniel Varro - Initial API and implementation

%options escape=$
%options fp=VTCLLexer,prefix=Char_
%options la=2
%options single-productions
%options package=org.eclipse.viatra2.lpgparser
%options template=LexerTemplateD.g
%options filter=VTCLKWLexer.g
%options export_terminals=("VTCLParsersym.java", "TK_")

$Define

--	$action_class /.$file_prefix./
--	$prs_stream_class /.PrsStream./
--	$eof_token /.$_EOF_TOKEN./
    --
    -- Definition of macro used in the included file LexerBasicMapB.g
    --
    $kw_lexer_class /.$VTCLKWLexer./

$End

$Notice
	/./**
 * Copyright (c) 2007 OptXware Research and Development LLC.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Daniel Varro - Initial API and implementation
 *
 * This file was generated automatically based upon the VTCL LPG Lexer
 * VTCLLexer.g 
 */
	./
$End

-- $Globals
-- $End

$Include
    LexerBasicMap.g
$End

-- $Headers
-- $End


$Export

    SlComment
    MlComment
    DocComment

    IDENTIFIER
    StringLiteral
    IntegerLiteral
--    LongLiteral
    FloatingPointLiteral
    DoubleLiteral
    NameLiteral
    AnnotationLiteral
    UpperCaseLiteral
    DummyVariableLiteral
    DecimalIntegerLiteral
    
--    PLUS_PLUS
--    MINUS_MINUS
    EQUAL_EQUAL
    LESS_EQUAL
    GREATER_EQUAL
    NOT_EQUAL
    NONINJECTIVE
    LEFT_SHIFT
    RIGHT_SHIFT
--    UNSIGNED_RIGHT_SHIFT
--    PLUS_EQUAL
--    MINUS_EQUAL
--    MULTIPLY_EQUAL
--    DIVIDE_EQUAL
--    AND_EQUAL
--    OR_EQUAL
--    XOR_EQUAL
--    REMAINDER_EQUAL
--    LEFT_SHIFT_EQUAL
--    RIGHT_SHIFT_EQUAL
--    UNSIGNED_RIGHT_SHIFT_EQUAL
    OR_OR
    AND_AND
    PLUS
    MINUS
    NOT
    REMAINDER
    XOR
    AND
    MULTIPLY
    OR
    TWIDDLE
    DIVIDE
    GREATER
    LESS
    LPAREN
    RPAREN
    LBRACE
    RBRACE
    LBRACKET
    RBRACKET
    SEMICOLON
    QUESTION
    COLON
    COMMA
    DOT
    EQUAL
    RIGHTARROW
    HASHMARK

$End

$Terminals
    CtlCharNotWS

    LF   CR   HT   FF

    a    b    c    d    e    f    g    h    i    j    k    l    m
    n    o    p    q    r    s    t    u    v    w    x    y    z
    _

    A    B    C    D    E    F    G    H    I    J    K    L    M
    N    O    P    Q    R    S    T    U    V    W    X    Y    Z

    0    1    2    3    4    5    6    7    8    9

    Space        ::= ' '
    AfterASCII   ::= '\u0080..\ufffe'
    LF           ::= NewLine
    CR           ::= Return
    HT           ::= HorizontalTab
    FF           ::= FormFeed
    DoubleQuote  ::= '"'
    SingleQuote  ::= "'"
    Percent      ::= '%'
    VerticalBar  ::= '|'
    Exclamation  ::= '!'
    AtSign       ::= '@'
    BackQuote    ::= '`'
    Tilde        ::= '~'
    Sharp        ::= '#'
    DollarSign   ::= '$'
    Ampersand    ::= '&'
    Caret        ::= '^'
    Colon        ::= ':'
    SemiColon    ::= ';'
    BackSlash    ::= '\'
    LeftBrace    ::= '{'
    RightBrace   ::= '}'
    LeftBracket  ::= '['
    RightBracket ::= ']'
    QuestionMark ::= '?'
    Comma        ::= ','
    Dot          ::= '.'
    LessThan     ::= '<'
    GreaterThan  ::= '>'
    Plus         ::= '+'
    Minus        ::= '-'
    Slash        ::= '/'
    Star         ::= '*'
    LeftParen    ::= '('
    RightParen   ::= ')'
    Equal        ::= '='
    
$End

$Start
    Token
$End

$Rules

    ---------------------  Rules for Scanned Tokens --------------------------------
    -- The lexer creates an array list of tokens which is defined in the PrsStream class.
    -- A token has three attributes: a start offset, an end offset and a kind.
    -- 
    -- Only rules that produce complete tokens have actions to create token objects.
    -- When making a token, calls to the methods, $getToken(1) and $getRightSpan(), 
    -- provide the offsets (i.e. the span) of a rule's right hand side (rhs) and thus of the token.
    -- For a rule of the form A ::= A1 A2 ... An, the start offset of the rhs of A is given by
    -- $getToken(1) or by $getLeftSpan() and the end offset by $getRightSpan().
    --  
    -- Regarding rules for parsing in general, note that for a rhs symbol Ai, the 
    -- method $getToken(i) returns the location of the leftmost character derived from Ai.  
    -- The method $getLeftSpan(i) returns the same location unless Ai produces $empty in which case
    -- it returns the location of the last character derived before reducing Ai to $empty. 
    -- The method $getRightSpan(i) returns the location of the rightmost character derived from Ai 
    -- unless Ai produces $empty in which case it returns the location of the last character 
    -- derived before reducing Ai to $empty.
    --------------------------------------------------------------------------------
    
    -- Identifier corresponds to alphanum
    Token ::= Identifier
        /.$BeginAction
                    checkForKeyWord();
          $EndAction
        ./
    Token ::= DoubleQuote SLBody DoubleQuote
        /.$BeginAction
                    makeToken($_StringLiteral);
          $EndAction
        ./
    Token ::= SingleQuote NameBody SingleQuote 
        /.$BeginAction
                    makeToken($_NameLiteral);
          $EndAction
        ./
    Token ::= AtSign LiteralStartsWithLetter
        /.$BeginAction
                    makeToken($_AnnotationLiteral);
          $EndAction
        ./
    Token ::= UpperCaseLiteral
        /.$BeginAction
                    makeToken($_UpperCaseLiteral);
          $EndAction
        ./

    Token ::= DummyVariableLiteral
        /.$BeginAction
                    makeToken($_DummyVariableLiteral);
          $EndAction
        ./
        
    Token ::= IntegerLiteral
        /.$BeginAction
                    makeToken($_IntegerLiteral);
          $EndAction
        ./
    Token ::= DecimalIntegerLiteral
        /.$BeginAction
                    makeToken($_DecimalIntegerLiteral);
          $EndAction
        ./
    Token ::= FloatingPointLiteral
        /.$BeginAction
                    makeToken($_FloatingPointLiteral);
          $EndAction
        ./
    Token ::= DoubleLiteral
        /.$BeginAction
                    makeToken($_DoubleLiteral);
          $EndAction
        ./
    Token ::= '/' '*' Inside Stars '/'
        /.$BeginAction
					makeComment($_MlComment);
          $EndAction
        ./
    Token ::= '/' '*' '*' Inside Stars '/'
        /.$BeginAction
                      makeComment($_DocComment);
          $EndAction
        ./
    Token ::= SLC
        /.$BeginAction
                    makeComment($_SlComment);
          $EndAction
        ./
    Token ::= WS -- White Space is scanned but not added to output vector
        /.$BeginAction
                    skipToken();
          $EndAction
        ./
    Token ::= '+'
        /.$BeginAction
                    makeToken($_PLUS);
          $EndAction
        ./
    Token ::= '-'
        /.$BeginAction
                    makeToken($_MINUS);
          $EndAction
        ./

    Token ::= '*'
        /.$BeginAction
                    makeToken($_MULTIPLY);
          $EndAction
        ./

    Token ::= '/'
        /.$BeginAction
                    makeToken($_DIVIDE);
          $EndAction
        ./

    Token ::= '('
        /.$BeginAction
                    makeToken($_LPAREN);
          $EndAction
        ./

    Token ::= ')'
        /.$BeginAction
                    makeToken($_RPAREN);
          $EndAction
        ./

    Token ::= '='
        /.$BeginAction
                    makeToken($_EQUAL);
          $EndAction
        ./

    Token ::= ','
        /.$BeginAction
                    makeToken($_COMMA);
          $EndAction
        ./

    Token ::= ':'
        /.$BeginAction
                    makeToken($_COLON);
          $EndAction
        ./

    Token ::= ';'
        /.$BeginAction
                    makeToken($_SEMICOLON);
          $EndAction
        ./

    Token ::= '^'
        /.$BeginAction
                    makeToken($_XOR);
          $EndAction
        ./

    Token ::= '%'
        /.$BeginAction
                    makeToken($_REMAINDER);
          $EndAction
        ./

    Token ::= '~'
        /.$BeginAction
                    makeToken($_TWIDDLE);
          $EndAction
        ./

    Token ::= '|'
        /.$BeginAction
                    makeToken($_OR);
          $EndAction
        ./

    Token ::= '&'
        /.$BeginAction
                    makeToken($_AND);
          $EndAction
        ./

    Token ::= '<'
        /.$BeginAction
                    makeToken($_LESS);
          $EndAction
        ./

    Token ::= '>'
        /.$BeginAction
                    makeToken($_GREATER);
          $EndAction
        ./

    Token ::= '.'
        /.$BeginAction
                    makeToken($_DOT);
          $EndAction
        ./

    Token ::= '!'
        /.$BeginAction
                    makeToken($_NOT);
          $EndAction
        ./

    Token ::= '['
        /.$BeginAction
                    makeToken($_LBRACKET);
          $EndAction
        ./

    Token ::= ']'
        /.$BeginAction
                    makeToken($_RBRACKET);
          $EndAction
        ./

    Token ::= '{'
        /.$BeginAction
                    makeToken($_LBRACE);
          $EndAction
        ./

    Token ::= '}'
        /.$BeginAction
                    makeToken($_RBRACE);
          $EndAction
        ./

    Token ::= '?'
        /.$BeginAction
                    makeToken($_QUESTION);
          $EndAction
        ./

    Token ::= '#'
        /.$BeginAction
                    makeToken($_HASHMARK);
          $EndAction
        ./

--    Token ::= '+' '+'
--        /.$BeginAction
--                    makeToken($_PLUS_PLUS);
--          $EndAction
--        ./

--    Token ::= '-' '-'
--        /.$BeginAction
--                    makeToken($_MINUS_MINUS);
--          $EndAction
--        ./

    Token ::= '=' '='
        /.$BeginAction
                    makeToken($_EQUAL_EQUAL);
          $EndAction
        ./

    Token ::= '<' '='
        /.$BeginAction
                    makeToken($_LESS_EQUAL);
          $EndAction
        ./

    Token ::= '>' '='
        /.$BeginAction
                    makeToken($_GREATER_EQUAL);
          $EndAction
        ./

    Token ::= '!' '='
        /.$BeginAction
                    makeToken($_NOT_EQUAL);
          $EndAction
        ./

    Token ::= '=' '/' '='
        /.$BeginAction
                    makeToken($_NONINJECTIVE);
          $EndAction
        ./

--    Token ::= '<' '<'
--        /.$BeginAction
--                    makeToken($_LEFT_SHIFT);
--          $EndAction
--        ./

--    Token ::= '>' '>'
--        /.$BeginAction
--                    makeToken($_RIGHT_SHIFT);
--          $EndAction
--        ./

--    Token ::= '>' '>' '>'
--        /.$BeginAction
--                    makeToken($_UNSIGNED_RIGHT_SHIFT);
--          $EndAction
--        ./

--    Token ::= '+' '='
--        /.$BeginAction
--                    makeToken($_PLUS_EQUAL);
--          $EndAction
--        ./

--    Token ::= '-' '='
--        /.$BeginAction
--                    makeToken($_MINUS_EQUAL);
--          $EndAction
--        ./

--    Token ::= '*' '='
--        /.$BeginAction
--                    makeToken($_MULTIPLY_EQUAL);
--          $EndAction
--        ./

--    Token ::= '/' '='
--        /.$BeginAction
--                    makeToken($_DIVIDE_EQUAL);
--          $EndAction
--        ./

--    Token ::= '&' '='
--        /.$BeginAction
--                    makeToken($_AND_EQUAL);
--          $EndAction
--        ./

--    Token ::= '|' '='
--        /.$BeginAction
--                    makeToken($_OR_EQUAL);
--          $EndAction
--        ./

--    Token ::= '^' '='
--        /.$BeginAction
--                    makeToken($_XOR_EQUAL);
--          $EndAction
--        ./

--    Token ::= '%' '='
--        /.$BeginAction
--                    makeToken($_REMAINDER_EQUAL);
--          $EndAction
--        ./

--    Token ::= '<' '<' '='
--        /.$BeginAction
--                    makeToken($_LEFT_SHIFT_EQUAL);
--          $EndAction
--        ./

--    Token ::= '>' '>' '='
--        /.$BeginAction
--                    makeToken($_RIGHT_SHIFT_EQUAL);
--          $EndAction
--        ./

--    Token ::= '>' '>' '>' '='
--        /.$BeginAction
--                   makeToken($_UNSIGNED_RIGHT_SHIFT_EQUAL);
--          $EndAction
--        ./

    Token ::= '|' '|'
        /.$BeginAction
                    makeToken($_OR_OR);
          $EndAction
        ./

    Token ::= '&' '&'
        /.$BeginAction
                    makeToken($_AND_AND);
          $EndAction
        ./

    Token ::= '-' '>'
        /.$BeginAction
                    makeToken($_RIGHTARROW);
          $EndAction
        ./

--    Identifier -> Letter
--                | Identifier Letter
--                | Identifier Digit
--                | Identifier _

    Identifier -> LowerCaseLetter
	        | LowerCaseLetter Alphanum

    DummyVariableLiteral -> _
          | _ Alphanum
          
    UpperCaseLiteral -> UpperCaseLetter
		      | UpperCaseLetter Alphanum

    LiteralStartsWithLetter -> Identifier 
                             | UpperCaseLiteral

    DecimalIntegerLiteral -> Integer

    IntegerLiteral -> -- Integer | 
                      Integer LetterLl
                    | '0' LetterXx HexDigits
                    | '0' LetterXx HexDigits LetterLl

    DoubleLiteral -> Decimal
                   | Decimal LetterForD
                   | Decimal Exponent
                   | Decimal Exponent LetterForD
                   | Integer Exponent
                   | Integer Exponent LetterForD
                   | Integer LetterForD

    FloatingPointLiteral -> Decimal LetterForF
                          | Decimal Exponent LetterForF
                          | Integer Exponent LetterForF
                          | Integer LetterForF

    Inside ::= Inside Stars NotSlashOrStar
             | Inside '/'
             | Inside NotSlashOrStar
             | $empty

    Stars -> '*'
           | Stars '*'

    SLC ::= '/' '/'
          | SLC NotEol

    SLBody ::= $empty
             | SLBody NotDQ

    NameBody -> NotSQNotDot 
   	      | NameBody NotSQNotDot

	
	-- Alphanum can consist of a single _
    Alphanum ->  Letter
	       | Digit
               | Alphanum Letter 
               | Alphanum Digit 

	
    Integer -> Digit
             | Integer Digit

    HexDigits -> HexDigit
               | HexDigits HexDigit

    Decimal ::= '.' Integer
              | Integer '.'
              | Integer '.' Integer

    Exponent ::= LetterEe Integer
               | LetterEe '-' Integer
               | LetterEe '+' Integer

    WSChar -> Space
            | LF
            | CR
            | HT
            | FF

    Letter -> LowerCaseLetter
            | UpperCaseLetter
            | _
            | '$'
            | AfterASCII

    LowerCaseLetter -> a | b | c | d | e | f | g | h | i | j | k | l | m |
                       n | o | p | q | r | s | t | u | v | w | x | y | z --|
                       --� | � | � | � | � | � | � | � 

    UpperCaseLetter -> A | B | C | D | E | F | G | H | I | J | K | L | M |
                       N | O | P | Q | R | S | T | U | V | W | X | Y | Z --|
                       --� | � | � | � | � | � | � | � 
                       

    Digit -> 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9

    OctalDigit -> 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7

    a..f -> a | b | c | d | e | f | A | B | C | D | E | F

    HexDigit -> Digit
              | a..f

--    OctalDigits3 -> OctalDigit
--                  | OctalDigit OctalDigit
--                  | OctalDigit OctalDigit OctalDigit

    LetterForD -> 'D'
                | 'd'

    LetterForF -> 'F'
                | 'f'

    LetterLl -> 'L'
              | 'l'

    LetterEe -> 'E'
              | 'e'

    LetterXx -> 'X'
              | 'x'


    WS -> WSChar
        | WS WSChar


    SpecialNotStar -> '+' | '-' | '/' | '(' | ')' | '"' | '!' | '@' | '`' | '~' |
                      '%' | '&' | '^' | ':' | ';' | "'" | '\' | '|' | '{' | '}' |
                      '[' | ']' | '?' | ',' | '.' | '<' | '>' | '=' | '#'

    SpecialNotSlash -> '+' | '-' | -- exclude the star as well
                       '(' | ')' | '"' | '!' | '@' | '`' | '~' |
                       '%' | '&' | '^' | ':' | ';' | "'" | '\' | '|' | '{' | '}' |
                       '[' | ']' | '?' | ',' | '.' | '<' | '>' | '=' | '#'

    SpecialNotDQ -> '+' | '-' | '/' | '(' | ')' | '*' | '!' | '@' | '`' | '~' |
                    '%' | '&' | '^' | ':' | ';' | "'" | '|' | '{' | '}' |
                    '[' | ']' | '?' | ',' | '.' | '<' | '>' | '=' | '#'

--    SpecialNotSQ -> '+' | '-' | '*' | '(' | ')' | '"' | '!' | '@' | '`' | '~' |
--                    '%' | '&' | '^' | ':' | ';' | '/' | '|' | '{' | '}' |
--                    '[' | ']' | '?' | ',' | '.' | '<' | '>' | '=' | '#'

    SpecialNotSQNotDot -> '+' | '-' | '*' | '(' | ')' | '"' | '!' | '@' | '`' | '~' |
                    '%' | '&' | '^' | ':' | ';' | '/' | '|' | '{' | '}' |
                    '[' | ']' | '?' | ',' | '<' | '>' | '=' | '#'

    NotSlashOrStar -> Letter
                    | Digit
                    | SpecialNotSlash
                    | WSChar

    NotEol -> Letter
            | Digit
            | Space
            | '*'
            | SpecialNotStar
            | HT
            | FF
            | CtlCharNotWS

    NotDQ -> Letter
           | Digit
           | SpecialNotDQ
           | Space
           | HT
           | FF
           | EscapeSequence
           | '\' u HexDigit HexDigit HexDigit HexDigit
           | '\' OctalDigit

--    NotSQ -> Letter
--           | Digit
--           | SpecialNotSQ
--           | Space
--           | HT
--           | FF
--           | EscapeSequence
--           | '\' u HexDigit HexDigit HexDigit HexDigit
--           | '\' OctalDigits3
	
	NotSQNotDot -> Letter
           | Digit
           | SpecialNotSQNotDot
	
    EscapeSequence ::= '\' b
                     | '\' t
                     | '\' n
                     | '\' f
                     | '\' r
                     | '\' '"'
                     | '\' "'"
                     | '\' '\'
$End
