/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.extensions.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.viatra2.visualisation.ViatraColoredLabelProvider;
import org.eclipse.viatra2.visualisation.VisualisationPlugin;
import org.eclipse.viatra2.visualisation.common.extensions.Category;
import org.eclipse.viatra2.visualisation.common.extensions.FilterConfiguration;
import org.eclipse.viatra2.visualisation.common.extensions.NamedElement;
import org.eclipse.viatra2.visualisation.common.extensions.VisualisationPreset;
import org.eclipse.viatra2.visualisation.layouts.IViatraLayoutAlgorithm;
import org.osgi.framework.Bundle;

public class ExtensionAccess {
    private static final String ExtensionID = "org.eclipse.viatra2.visualisation.customization";
    public static final ExtensionAccess instance = new ExtensionAccess();
    private Category defaultCategory;
    Map<String, Category> categories;

    private ExtensionAccess() {
    }

    public static void reInit() {
        instance.readExtensionPoint();
    }

    public static SortedSet<Category> getAllCategories() {
        TreeSet<Category> sortedCategores = new TreeSet<Category>(new CategoryComparator());
        sortedCategores.addAll(ExtensionAccess.instance.categories.values());
        return sortedCategores;
    }

    public static Collection<NamedElement<IViatraLayoutAlgorithm>> getAllLayoutAlgorithms() {
        return ExtensionAccess.instance.defaultCategory.layouts.values();
    }

    public static Collection<NamedElement<ViatraColoredLabelProvider>> getAllLabelProviders() {
        return ExtensionAccess.instance.defaultCategory.labelproviders.values();
    }

    public static Collection<NamedElement<ViewerFilter>> getAllFilters() {
        return ExtensionAccess.instance.defaultCategory.filters.values();
    }

    public static Collection<NamedElement<VisualisationPreset>> getAllPresets() {
        return ExtensionAccess.instance.defaultCategory.presets.values();
    }

    public static Category getCategoryById(String id) {
        return ExtensionAccess.instance.categories.get(id);
    }

    public static Collection<NamedElement<FilterConfiguration>> getAllFilterConfigurations() {
        return ExtensionAccess.instance.defaultCategory.filterConfigurations.values();
    }

    private void _readCategories() {
        IConfigurationElement[] config;
        this.categories = new HashMap<String, Category>();
        this.defaultCategory = new Category("default", "default", "default");
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if ("category".equals(element.getName())) {
                    String name = element.getAttribute("name");
                    String id = element.getAttribute("id");
                    String orderid = element.getAttribute("orderID");
                    Category c = new Category(id, name, orderid);
                    this.categories.put(id, c);
                }
            }
            catch (Exception e) {
                Platform.getLog((Bundle)VisualisationPlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.viatra2.visualisation", e.getMessage()));
            }
            ++n2;
        }
    }

    private <T> void registerElement(IConfigurationElement element, String attrName, Map<String, NamedElement<T>> genericTargetMap, Map<String, NamedElement<T>> specificTargetMap) throws CoreException {
        String name = element.getAttribute("name");
        String id = element.getAttribute("id");
        Object obj = element.createExecutableExtension(attrName);
        NamedElement<Object> ne = new NamedElement<Object>(name, obj);
        genericTargetMap.put(id, ne);
        if (specificTargetMap != null) {
            specificTargetMap.put(id, ne);
        }
    }

    private void _readExecutables() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Map<String, NamedElement<Object>> map;
                if ("algorithm".equals(element.getName())) {
                    map = null;
                    if (element.getAttribute("category") != null) {
                        map = this.categories.get((Object)element.getAttribute((String)"category")).layouts;
                    }
                    this.registerElement(element, "layoutalgorithm", this.defaultCategory.layouts, map);
                } else if ("filter".equals(element.getName())) {
                    map = null;
                    if (element.getAttribute("category") != null) {
                        map = this.categories.get((Object)element.getAttribute((String)"category")).filters;
                    }
                    this.registerElement(element, "filter", this.defaultCategory.filters, map);
                } else if ("labelprovider".equals(element.getName())) {
                    map = null;
                    if (element.getAttribute("category") != null) {
                        map = this.categories.get((Object)element.getAttribute((String)"category")).labelproviders;
                    }
                    this.registerElement(element, "labelprovider", this.defaultCategory.labelproviders, map);
                }
            }
            catch (Exception e) {
                Platform.getLog((Bundle)VisualisationPlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.viatra2.visualisation", e.getMessage()));
            }
            ++n2;
        }
    }

    private void _readFilterConfigurations() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if ("filterconfiguration".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    String description = element.getAttribute("description");
                    FilterConfiguration fc = new FilterConfiguration(id, name, description);
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("filterreference");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cd = iConfigurationElementArray2[n4];
                        String filterID = cd.getAttribute("filterID");
                        if (filterID != null) {
                            fc.filters.add(this.defaultCategory.filters.get(filterID));
                        }
                        ++n4;
                    }
                    NamedElement<FilterConfiguration> _fc = new NamedElement<FilterConfiguration>(name, fc);
                    this.defaultCategory.filterConfigurations.put(id, _fc);
                    if (element.getAttribute("category") != null) {
                        this.categories.get((Object)element.getAttribute((String)"category")).filterConfigurations.put(id, _fc);
                    }
                }
            }
            catch (Exception e) {
                Platform.getLog((Bundle)VisualisationPlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.viatra2.visualisation", e.getMessage()));
            }
            ++n2;
        }
    }

    private void _readPresets() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if ("preset".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    NamedElement<IViatraLayoutAlgorithm> layout = this.defaultCategory.layouts.get(element.getAttribute("layout"));
                    NamedElement<ViatraColoredLabelProvider> labelprovider = this.defaultCategory.labelproviders.get(element.getAttribute("labelprovider"));
                    FilterConfiguration filterconfig = (FilterConfiguration)this.defaultCategory.filterConfigurations.get((Object)element.getAttribute((String)"filters")).element;
                    if (layout != null && labelprovider != null && filterconfig != null) {
                        VisualisationPreset vp = new VisualisationPreset(id, name, labelprovider, layout, filterconfig);
                        NamedElement<VisualisationPreset> vp_named = new NamedElement<VisualisationPreset>(name, vp);
                        this.defaultCategory.presets.put(id, vp_named);
                        Map<String, NamedElement<VisualisationPreset>> map = null;
                        if (element.getAttribute("category") != null) {
                            map = this.categories.get((Object)element.getAttribute((String)"category")).presets;
                            map.put(name, vp_named);
                        }
                    }
                }
            }
            catch (Exception e) {
                Platform.getLog((Bundle)VisualisationPlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.viatra2.visualisation", e.getMessage()));
            }
            ++n2;
        }
    }

    private void readExtensionPoint() {
        this._readCategories();
        this._readExecutables();
        this._readFilterConfigurations();
        this._readPresets();
    }

    private static class CategoryComparator
    implements Comparator<Category>,
    Serializable {
        private static final long serialVersionUID = 6726325608227073546L;

        private CategoryComparator() {
        }

        @Override
        public int compare(Category o1, Category o2) {
            String order1 = o1.orderID;
            String order2 = o2.orderID;
            int order = order1.compareTo(order2);
            if (order == 0) {
                order = o1.name.compareTo(o2.name);
            }
            if (order == 0) {
                order = o1.id.compareTo(o2.id);
            }
            return order;
        }
    }
}

