/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.labelproviders;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.visualisation.common.labelproviders.SmartLabelProvider;

public class HighlightableSmartLabelProvider
extends SmartLabelProvider {
    private static Map<String, Collection<WeakReference<IModelElement>>> highlightedElements = new TreeMap<String, Collection<WeakReference<IModelElement>>>();
    private static Map<String, Color> highlightColor = new TreeMap<String, Color>();
    private static ColorRegistry hlCReg = new ColorRegistry();
    private Color HL;
    private static final int highlightwidth = 3;

    public static void highlightElement(IModelElement me) {
        HighlightableSmartLabelProvider.highlightElement(me, null);
    }

    public static void highlightElement(IModelElement me, String colorKey) {
        String key = HighlightableSmartLabelProvider.getKey(me);
        Collection<WeakReference<IModelElement>> set = highlightedElements.get(key);
        if (set == null) {
            set = new ArrayList<WeakReference<IModelElement>>();
            highlightedElements.put(key, set);
        }
        set.add(new WeakReference<IModelElement>(me));
        if (colorKey != null && hlCReg.get(colorKey) != null) {
            highlightColor.put(key, hlCReg.get(colorKey));
        }
    }

    public static void clearHighlights(IModelSpace msp) {
        for (Collection<WeakReference<IModelElement>> c : highlightedElements.values()) {
            ArrayList<WeakReference<IModelElement>> toRemove = new ArrayList<WeakReference<IModelElement>>();
            for (WeakReference<IModelElement> wr : c) {
                if (!((IModelElement)wr.get()).getModelSpace().equals(msp)) continue;
                toRemove.add(wr);
            }
            c.removeAll(toRemove);
        }
    }

    private static String getKey(IModelElement me) {
        return me.getID();
    }

    public static void unhighlightElement(IModelElement me) {
        String key = HighlightableSmartLabelProvider.getKey(me);
        Collection<WeakReference<IModelElement>> set = highlightedElements.get(key);
        if (set != null) {
            WeakReference<IModelElement> toRemove = null;
            for (WeakReference<IModelElement> target : set) {
                if (!HighlightableSmartLabelProvider.Equals((IModelElement)target.get(), me)) continue;
                toRemove = target;
                break;
            }
            if (toRemove != null) {
                set.remove(toRemove);
            }
        }
        highlightColor.remove(key);
    }

    private static boolean Equals(IModelElement me0, IModelElement me1) {
        return me0.equals(me1) && me0.getModelSpace().equals(me1.getModelSpace());
    }

    public static boolean isHighlighted(IModelElement me) {
        String key = HighlightableSmartLabelProvider.getKey(me);
        Collection<WeakReference<IModelElement>> set = highlightedElements.get(key);
        if (set != null) {
            for (WeakReference<IModelElement> target : set) {
                if (!HighlightableSmartLabelProvider.Equals((IModelElement)target.get(), me)) continue;
                return true;
            }
        }
        return false;
    }

    public static String registerColor(int r, int g, int b) {
        RGB rgb = new RGB(r, g, b);
        if (hlCReg.get(rgb.toString()) == null) {
            hlCReg.put(rgb.toString(), rgb);
        }
        return rgb.toString();
    }

    public HighlightableSmartLabelProvider() {
        hlCReg.put("highlight", new RGB(255, 0, 0));
        this.HL = hlCReg.get("highlight");
    }

    @Override
    public int getBorderWidth(Object entity) {
        if (entity instanceof IModelElement && HighlightableSmartLabelProvider.isHighlighted((IModelElement)entity)) {
            return 3;
        }
        return super.getBorderWidth(entity);
    }

    @Override
    public Color getBorderColor(Object entity) {
        Color c = this._getColor(entity);
        return c != null ? c : super.getBorderColor(entity);
    }

    @Override
    public Color getBackgroundColour(Object entity) {
        Color c = this._getColor(entity);
        return c != null ? c : super.getBackgroundColour(entity);
    }

    @Override
    public int getLineWidth(Object rel) {
        if (rel instanceof IModelElement && HighlightableSmartLabelProvider.isHighlighted((IModelElement)rel)) {
            return 3;
        }
        return super.getLineWidth(rel);
    }

    @Override
    public Color getColor(Object entity) {
        Color c = this._getColor(entity);
        return c != null ? c : super.getColor(entity);
    }

    private Color _getColor(Object entity) {
        if (entity instanceof IModelElement && HighlightableSmartLabelProvider.isHighlighted((IModelElement)entity)) {
            Color c = highlightColor.get(HighlightableSmartLabelProvider.getKey((IModelElement)entity));
            if (c != null) {
                return c;
            }
            return this.HL;
        }
        return null;
    }
}

