/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.labelproviders.internal;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.viatra2.visualisation.common.labelproviders.internal.ColorFactory;
import org.eclipse.viatra2.visualisation.common.labelproviders.internal.ShapeCenteringFigure;

public class ImageCenteringFigure
extends ShapeCenteringFigure {
    private Image im;

    public ImageCenteringFigure(boolean needBorder, Image image, String labelText, IFigure tooltip) {
        super(needBorder, labelText, tooltip);
        this.im = image;
    }

    public ImageCenteringFigure(Image image, String labelText, IFigure tooltip) {
        super(false, labelText, tooltip);
        this.im = image;
    }

    @Override
    protected Dimension getShapeDimension() {
        if (this.im != null) {
            Rectangle bounds = this.im.getBounds();
            return new Dimension(bounds.width, bounds.height);
        }
        return new Dimension(50, 50);
    }

    @Override
    protected void createShapeFigure() {
        this.iShapeFigure = new ImageShape();
        this.iShapeFigure.setOpaque(false);
        this.iShapeFigure.setBackgroundColor(ColorFactory.getColor(239, 235, 231));
        this.iShapeFigure.setForegroundColor(ColorFactory.getColor(70, 70, 70));
        this.iShapeFigure.setSize(this.getShapeDimension());
    }

    public class ImageShape
    extends Shape {
        protected void fillShape(Graphics graphics) {
            org.eclipse.draw2d.geometry.Rectangle ca = this.getClientArea();
            Rectangle bounds = ImageCenteringFigure.this.im.getBounds();
            graphics.drawImage(ImageCenteringFigure.this.im, 0, 0, bounds.width, bounds.height, ca.x, ca.y, ca.width, ca.height);
        }

        protected void outlineShape(Graphics graphics) {
        }
    }
}

