/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.NotificationType;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.ViatraColoredLabelProvider;
import org.eclipse.viatra2.visualisation.ViatraGraphViewer;
import org.eclipse.viatra2.visualisation.common.extensions.FilterConfiguration;
import org.eclipse.viatra2.visualisation.common.extensions.NamedElement;
import org.eclipse.viatra2.visualisation.common.extensions.VisualisationPreset;
import org.eclipse.viatra2.visualisation.layouts.IViatraLayoutAlgorithm;
import org.eclipse.viatra2.visualisation.modelspace.ModelSpaceGraphViewer;
import org.eclipse.viatra2.visualisation.modelspace.ModelspaceTransactionChanges;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.FilterGroup;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.ModelSpaceProviderGroup;
import org.eclipse.viatra2.visualisation.modelspace.datasource.AbstractModelSpaceProvider;
import org.eclipse.viatra2.visualisation.modelspace.datasource.filter.PostFilter;
import org.eclipse.viatra2.visualisation.modelspace.datasource.filter.PreFilter;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;

public class ModelSpaceVisualisationDescriptor
implements IVisualisationDescriptor {
    ModelSpaceGraphViewer gv;
    PreFilter preFilter = new PreFilter();
    PostFilter postFilter = new PostFilter();
    IModelManager modelManager;
    IFramework framework;
    ViatraTreeEditor editor;
    ModelSpaceProviderGroup providerGroup = new ModelSpaceProviderGroup();
    List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    private IFrameworkListChangedListener frameworkListener = new IFrameworkListChangedListener(){

        public void frameworkRemoved(IFramework f) {
            if (f.equals(ModelSpaceVisualisationDescriptor.this.framework)) {
                ModelSpaceVisualisationDescriptor.this.setFramework(null);
                ModelSpaceVisualisationDescriptor.this.setModelManager(null);
                ModelSpaceVisualisationDescriptor.this.clearGraphModel();
            }
        }

        public void frameworkAdded(IFramework f) {
        }
    };
    private ISelection localSelection;
    private ISelection remoteSelection;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (ModelSpaceVisualisationDescriptor.this.framework != null) {
                ISelection selection = event.getSelection();
                if (event.getSource().equals((Object)ModelSpaceVisualisationDescriptor.this.gv)) {
                    if (ModelSpaceVisualisationDescriptor.this.localSelection != null && ModelSpaceVisualisationDescriptor.this.localSelection.equals(selection)) {
                        return;
                    }
                    ViatraTreeEditor editor = ModelSpaceVisualisationDescriptor.this.getEditorPart(ModelSpaceVisualisationDescriptor.this.framework);
                    ModelSpaceVisualisationDescriptor.this.remoteSelection = selection;
                    if (editor != null) {
                        editor.getTreeViewer().setSelection(selection);
                    }
                } else {
                    if (ModelSpaceVisualisationDescriptor.this.remoteSelection != null && ModelSpaceVisualisationDescriptor.this.remoteSelection.equals(selection)) {
                        return;
                    }
                    ModelSpaceVisualisationDescriptor.this.gv.setSelection(selection);
                    ModelSpaceVisualisationDescriptor.this.localSelection = selection;
                }
            }
        }
    };
    private ICoreNotificationListener modelSpaceListener = new ICoreNotificationListener(){
        Stack<ModelspaceTransactionChanges> transactions = new Stack();
        ModelspaceTransactionChanges actual = new ModelspaceTransactionChanges();
        private ICoreNotificationObject notificationObject;

        private void updateGraph() {
            ModelSpaceVisualisationDescriptor.this.preFilter.removeDeletedElements(this.actual.getDeletedElements());
            this.actual.handleLooseEdges(ModelSpaceVisualisationDescriptor.this.preFilter);
            Collection<IModelElement> newElements = this.actual.getNewElements();
            Collection<IModelElement> deletedElements = this.actual.getDeletedElements();
            if (newElements.isEmpty() && deletedElements.isEmpty()) {
                return;
            }
            if (newElements.isEmpty()) {
                ModelSpaceVisualisationDescriptor.this.refreshGraph();
                return;
            }
            for (IModelElement element : newElements) {
                if (ModelSpaceVisualisationDescriptor.this.preFilter.isFiltered(element)) continue;
                ModelSpaceVisualisationDescriptor.this.redrawGraph();
                return;
            }
        }

        public int getListenerCategory() {
            return 0;
        }

        public void actionPerformed(ICoreNotificationObject notification) {
            this.notificationObject = notification;
            NotificationType action = this.notificationObject.getActionTypeEnum();
            switch (action) {
                case TA_SUBTRANSACTION_END: 
                case TA_TRANSACTION_END: 
                case TA_UNDO_END: {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.updateGraph();
                            transactions.pop();
                        }
                    });
                    break;
                }
                case TA_UNDOABLE_TRANSACTION_BEGIN: 
                case TA_TRANSACTION_BEGIN: 
                case TA_SUBTRANSACTION_BEGIN: 
                case TA_UNDO_BEGIN: {
                    this.actual = new ModelspaceTransactionChanges();
                    this.transactions.push(this.actual);
                    break;
                }
                case ACTION_CREATE_ENTITY: 
                case ACTION_CREATE_RELATION: 
                case ACTION_SET_RELATION_FROM: 
                case ACTION_SET_RELATION_TO: 
                case ACTION_SET_NAME: 
                case ACTION_SET_ISANY: {
                    this.actual.addNewElements(this.notificationObject.getNotifiedObjects());
                    break;
                }
                case ACTION_DELETE_ENTITY: 
                case ACTION_DELETE_RELATION: 
                case ACTION_DELETE_INSTANCEOF: 
                case ACTION_DELETE_SUPERTYPEOF: {
                    this.actual.addRemovedElements(this.notificationObject.getNotifiedObjects());
                }
            }
        }
    };

    public ModelSpaceVisualisationDescriptor() {
        FrameworkManager.getInstance().addFrameworkListChangedListener(this.frameworkListener);
    }

    @Override
    public void addMenuContributions(IMenuManager manager) {
        this.providerGroup.fillContextMenu(manager);
        FilterGroup filters = new FilterGroup();
        filters.setFilter(this.postFilter);
        filters.fillContextMenu(manager);
    }

    @Override
    public void addToolbarContributions(IToolBarManager manager) {
    }

    @Override
    public ViatraGraphViewer getViewer() {
        return this.gv;
    }

    private ViatraGraphViewer initializeViewer(Composite parent) {
        this.gv = new ModelSpaceGraphViewer(parent, 0);
        this.gv.setConnectionStyle(2);
        this.gv.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(3), true);
        this.gv.setContentProvider(this.providerGroup.getDefaultProvider());
        this.gv.addFilter(this.postFilter);
        this.gv.setDescriptor(this);
        this.gv.addSelectionChangedListener(this.selectionListener);
        this.gv.setUseHashlookup(false);
        return this.gv;
    }

    @Override
    public void clearGraphModel() {
        this.preFilter = new PreFilter();
        for (AbstractModelSpaceProvider abstractModelSpaceProvider : this.providerGroup.getProviders()) {
            abstractModelSpaceProvider.setFilter(this.preFilter);
        }
        this.gv.setInput(new Object());
    }

    @Override
    public void removeSelection() {
        ISelection selection = this.gv.getSelection();
        if (!selection.isEmpty()) {
            this.excludeItems(((StructuredSelection)selection).toList());
        }
    }

    public void includeItem(IModelElement modelElement) {
        this.preFilter.includeSubtree(modelElement);
    }

    public void includeItems(List<IModelElement> elements) {
        for (IModelElement element : elements) {
            this.preFilter.includeElement(element);
        }
    }

    public void excludeItem(IModelElement modelElement) {
        this.preFilter.excludeSubtree(modelElement);
    }

    public void excludeItems(List<IModelElement> elements) {
        for (IModelElement element : elements) {
            this.preFilter.excludeElement(element);
        }
    }

    public IModelManager getModelManager() {
        return this.modelManager;
    }

    public IFramework getFramework() {
        return this.framework;
    }

    public void setFramework(IFramework framework) {
        if (this.framework != null) {
            this.framework.getTopmodel().getNotificationManager().removeAllListener(this.modelSpaceListener);
        }
        this.framework = framework;
        if (this.editor != null) {
            this.editor.getTreeViewer().removeSelectionChangedListener(this.selectionListener);
        }
        if (framework != null) {
            framework.getTopmodel().getNotificationManager().addAllListener(this.modelSpaceListener);
            this.editor = this.getEditorPart(framework);
            assert (this.editor != null) : "An editor should be open now";
            this.editor.getTreeViewer().addSelectionChangedListener(this.selectionListener);
        }
        this.clearGraphModel();
    }

    public void setModelManager(IModelManager manager) {
        this.modelManager = manager;
        for (AbstractModelSpaceProvider abstractModelSpaceProvider : this.providerGroup.getProviders()) {
            abstractModelSpaceProvider.setModelManager(this.modelManager);
        }
        this.gv.setInput(new Object());
    }

    public ViatraTreeEditor getEditorPart(IFramework framework) {
        if (this.editor == null) {
            IEditorPart editor;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String filename = framework.getCurrentFilename();
            IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
            IPath path = ws.getFullPath().append(filename.replace("\\", "/"));
            if (Platform.getOS().equals("win32")) {
                path = path.setDevice(filename.substring(0, 2));
            }
            if ((editor = page.findEditor((IEditorInput)new FileEditorInput(ws.getFileForLocation(path)))) instanceof ViatraTreeEditor) {
                return (ViatraTreeEditor)editor;
            }
        }
        return null;
    }

    public void dispose() {
        FrameworkManager.getInstance().removeFrameworkListChangedListener(this.frameworkListener);
        if (this.framework != null) {
            this.framework.getTopmodel().getNotificationManager().removeAllListener(this.modelSpaceListener);
        }
    }

    public Object getAdapter(Class adapter) {
        ViatraTreeEditor editor;
        if (adapter == IPropertySheetPage.class && this.framework != null && (editor = this.getEditorPart(this.framework)) != null) {
            return editor.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public void redrawGraph() {
        this.gv.setInput(new Object());
    }

    @Override
    public void refreshGraph() {
        this.gv.refresh();
        if (this.framework != null && this.modelManager != null && this.localSelection != null) {
            this.gv.setSelection(this.localSelection);
        }
    }

    @Override
    public void createFormContributions(Composite parent) {
        this.initializeViewer(parent);
    }

    @Override
    public void setLayoutAlgorithm(IViatraLayoutAlgorithm algorithm) {
        this.gv.setLayoutAlgorithm(algorithm.getAlgorithm(), true);
        this.gv.applyLayout();
    }

    @Override
    public void setVisualisationPreset(VisualisationPreset vp) {
        this.setFilterConfiguration(vp.filters, false);
        this.gv.setLayoutAlgorithm(((IViatraLayoutAlgorithm)vp.layout.element).getAlgorithm(), false);
        this.setLabelProvider((ViatraColoredLabelProvider)((Object)vp.labelprovider.element), false);
        this.gv.applyLayout();
    }

    @Override
    public void setLabelProvider(ViatraColoredLabelProvider provider) {
        this.setLabelProvider(provider, true);
    }

    @Override
    public void setLabelProvider(ViatraColoredLabelProvider provider, boolean doRefresh) {
        this.gv.setLabelProvider((IBaseLabelProvider)provider);
        if (doRefresh) {
            this.gv.refresh();
        }
    }

    @Override
    public void setFilterConfiguration(FilterConfiguration fc) {
        this.setFilterConfiguration(fc, true);
    }

    @Override
    public void setFilterConfiguration(FilterConfiguration fc, boolean doRefresh) {
        ArrayList<ViewerFilter> filtersToBeRemoved = new ArrayList<ViewerFilter>(this.filters);
        ArrayList<ViewerFilter> filtersToBeAdded = new ArrayList<ViewerFilter>();
        for (NamedElement<ViewerFilter> _filter : fc.filters) {
            filtersToBeRemoved.remove(_filter.element);
            if (this.filters.contains(_filter.element)) continue;
            filtersToBeAdded.add((ViewerFilter)_filter.element);
        }
        for (ViewerFilter filter : filtersToBeRemoved) {
            this.gv.removeFilter(filter);
            this.filters.remove(filter);
        }
        for (ViewerFilter filter : filtersToBeAdded) {
            this.gv.addFilter(filter);
            this.filters.add(filter);
        }
        if (doRefresh) {
            this.gv.refresh();
        }
    }
}

