/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.datasource;

import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.tags.ITag;
import org.eclipse.viatra2.visualisation.ViatraColoredLabelProvider;
import org.eclipse.viatra2.visualisation.modelspace.datasource.GraphArc;
import org.eclipse.viatra2.visualisation.modelspace.datasource.GraphRelationArc;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;

public class ModelSpaceLabelProvider
extends ViatraColoredLabelProvider
implements IEntityStyleProvider,
IConnectionStyleProvider {
    protected static String getShortText(String originalText) {
        int length = originalText.length();
        if (length > 15) {
            String text = String.valueOf(originalText.substring(0, 6)) + "..." + originalText.substring(length - 6, length - 1);
            return text;
        }
        return originalText;
    }

    protected static String getTypeAsString(IModelElement modelElement) {
        String name = "";
        if (!modelElement.getTypes().isEmpty()) {
            name = String.valueOf(name) + ((IModelElement)modelElement.getTypes().iterator().next()).getName();
        }
        return name;
    }

    public String getText(Object element) {
        String name;
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            name = String.valueOf(modelElement.getName()) + " : " + ModelSpaceLabelProvider.getShortText(ModelSpaceLabelProvider.getTypeAsString(modelElement));
        } else if (element instanceof GraphArc) {
            GraphArc arc = (GraphArc)element;
            name = arc.getName();
        } else {
            return null;
        }
        return name;
    }

    public boolean fisheyeNode(Object entity) {
        return true;
    }

    public Color getBackgroundColour(Object entity) {
        Set tags;
        IFramework fw;
        IModelSpace modelSpace = ((IModelElement)entity).getModelSpace();
        if (modelSpace != null && (fw = modelSpace.getFramework()) != null && (tags = fw.getTagManager().getTagsForModelElement((IModelElement)entity)) != null && !tags.isEmpty()) {
            return Display.getDefault().getSystemColor(((ITag)tags.iterator().next()).getBackgroundColor());
        }
        if (entity instanceof IRelation) {
            return this.RELATION_BG;
        }
        return this.ENTITY_BG;
    }

    public Color getBorderColor(Object entity) {
        if (entity instanceof IRelation) {
            return this.RELATION_BO;
        }
        return this.ENTITY_BO;
    }

    public Color getBorderHighlightColor(Object entity) {
        if (entity instanceof IRelation) {
            return this.RELATION_BOHL;
        }
        return this.ENTITY_BOHL;
    }

    public int getBorderWidth(Object entity) {
        return 1;
    }

    public Color getForegroundColour(Object entity) {
        if (entity instanceof IRelation) {
            return this.RELATION_FG;
        }
        return this.ENTITY_FG;
    }

    public Color getNodeHighlightColor(Object entity) {
        if (entity instanceof IRelation) {
            return this.RELATION_HL;
        }
        return this.ENTITY_HL;
    }

    public IFigure getTooltip(Object entity) {
        return null;
    }

    public Color getColor(Object rel) {
        return this.ARC;
    }

    public int getConnectionStyle(Object rel) {
        if (rel instanceof GraphArc && !(rel instanceof GraphRelationArc)) {
            return 16;
        }
        return 0;
    }

    public Color getHighlightColor(Object rel) {
        return this.ARC_HL;
    }

    public int getLineWidth(Object rel) {
        return 1;
    }
}

