/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.datasource.filter;

import java.util.Iterator;
import java.util.TreeSet;

class FilterCondition {
    protected TreeSet<String> subtreeFilters = new TreeSet();
    protected TreeSet<String> elementFilters = new TreeSet();

    FilterCondition() {
    }

    void addSubtreeFilterCondition(String id) {
        if (!this.subtreeFilters.contains(id)) {
            this.subtreeFilters.add(id);
        }
    }

    void addElementFilterCondition(String id) {
        if (!this.elementFilters.contains(id)) {
            this.elementFilters.add(id);
        }
    }

    boolean containsID(String id) {
        return this.elementFilters.contains(id) || this.subtreeFilters.contains(id);
    }

    boolean elementContainsID(String id) {
        return this.elementFilters.contains(id);
    }

    void removeFilter(String id, boolean isSubTree) {
        Iterator<String> it;
        if (id.equals("")) {
            this.subtreeFilters.clear();
            return;
        }
        if (isSubTree) {
            it = this.subtreeFilters.iterator();
            while (it.hasNext()) {
                if (!it.next().startsWith(id)) continue;
                it.remove();
            }
        }
        it = this.elementFilters.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith(id)) continue;
            it.remove();
        }
    }

    boolean isMatched(String id) {
        if (id == null || id.equals("")) {
            return this.subtreeFilters.contains("");
        }
        for (String filter : this.elementFilters) {
            if (!id.equals(filter)) continue;
            return true;
        }
        for (String filter : this.subtreeFilters) {
            if (!id.startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    String getMostSpecificMatch(String id) {
        if (this.subtreeFilters.contains(id) || id.equals("")) {
            return id;
        }
        if (this.elementFilters.contains(id)) {
            return id;
        }
        String[] elements = id.split("\\.");
        String newId = "";
        int i = 0;
        while (i < elements.length - 1) {
            newId = newId.concat(elements[i]);
            if (i != elements.length - 2) {
                newId = newId.concat(".");
            }
            ++i;
        }
        return this.getMostSpecificMatch(newId);
    }
}

