/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.ViatraColoredLabelProvider;
import org.eclipse.viatra2.visualisation.ViatraGraphViewer;
import org.eclipse.viatra2.visualisation.VisualisationPlugin;
import org.eclipse.viatra2.visualisation.common.extensions.FilterConfiguration;
import org.eclipse.viatra2.visualisation.common.extensions.NamedElement;
import org.eclipse.viatra2.visualisation.common.extensions.VisualisationPreset;
import org.eclipse.viatra2.visualisation.layouts.IViatraLayoutAlgorithm;
import org.eclipse.viatra2.visualisation.patterns.LocationElement;
import org.eclipse.viatra2.visualisation.patterns.PatternGraphViewer;
import org.eclipse.viatra2.visualisation.patterns.actions.PatternProviderGroup;
import org.eclipse.viatra2.visualisation.patterns.sources.PatternContentProvider;
import org.eclipse.viatra2.visualisation.patterns.sources.PatternLabelProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;

public class PatternGraphDescriptor
implements IVisualisationDescriptor,
ITabbedPropertySheetPageContributor {
    PatternGraphViewer gv;
    PatternProviderGroup providers = new PatternProviderGroup();
    PatternContentProvider contentProvider = this.providers.getDefaultProvider();
    PatternLabelProvider labelProvider = new PatternLabelProvider();
    Machine machine;
    String machineName;
    Hashtable<String, GTPattern> patternStorage;
    Combo list;
    LayoutAlgorithm layout;
    ArrayList<LocationElement> locationStack = new ArrayList();
    int locationID = 0;
    Action previousViewerAction = new Action(){

        public void run() {
            if (PatternGraphDescriptor.this.locationID > 0) {
                PatternGraphDescriptor.this.popItem();
            }
        }

        public boolean isEnabled() {
            return PatternGraphDescriptor.this.locationID > 1;
        }
    };
    private List<ViewerFilter> filters = new ArrayList<ViewerFilter>();

    public PatternGraphDescriptor() {
        this.previousViewerAction.setText("Back");
        this.previousViewerAction.setToolTipText("Displays the previous view");
        this.previousViewerAction.setImageDescriptor(VisualisationPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra2.visualisation", (String)"icons/nav_backward.gif"));
        this.previousViewerAction.setEnabled(false);
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.patternStorage = new Hashtable();
        for (GTPattern pattern : machine.getGtPatternDefinitions()) {
            this.patternStorage.put(pattern.getName(), pattern);
        }
        this.machineName = machine.getName();
    }

    @Override
    public void addMenuContributions(IMenuManager manager) {
        this.providers.fillContextMenu(manager);
    }

    @Override
    public void addToolbarContributions(IToolBarManager manager) {
        manager.add((IAction)this.previousViewerAction);
    }

    @Override
    public void clearGraphModel() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return null;
    }

    @Override
    public ViatraGraphViewer getViewer() {
        return this.gv;
    }

    private ViatraGraphViewer initializeViewer(Composite parent) {
        this.gv = new PatternGraphViewer(parent, 0);
        GridLayoutAlgorithm gridLayout = new GridLayoutAlgorithm(3);
        this.layout = new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new GridLayoutAlgorithm(1), new HorizontalShift(1)});
        this.gv.setCompoundLayout(this.layout);
        this.gv.setLayoutAlgorithm((LayoutAlgorithm)gridLayout);
        this.gv.setContentProvider((IContentProvider)this.contentProvider);
        this.gv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.gv.setNodeStyle(16);
        this.gv.setDescriptor(this);
        this.gv.setUseHashlookup(false);
        this.pushItem(this.machine);
        return this.gv;
    }

    @Override
    public void removeSelection() {
    }

    public void dispose() {
    }

    private void setViewerActionEnabled() {
        if (this.locationStack.size() > 1) {
            this.previousViewerAction.setEnabled(true);
        } else {
            this.previousViewerAction.setEnabled(false);
        }
    }

    public void pushItem(Object location) {
        if (this.locationStack.isEmpty() || !this.locationStack.get(this.locationID - 1).getInputElement().equals(location)) {
            LocationElement element = new LocationElement();
            element.setInputElement(location);
            this.locationStack.add(this.locationID, element);
            ++this.locationID;
        }
        this.gv.setInput(location);
        this.gv.refresh();
        if (location instanceof Machine) {
            this.list.setText(((Machine)location).getName());
        } else if (location instanceof GTPattern) {
            this.list.setText(((GTPattern)location).getName());
        }
        this.setViewerActionEnabled();
    }

    public void popItem() {
        --this.locationID;
        LocationElement element = this.locationStack.get(this.locationID);
        Object location = element.getInputElement();
        this.locationStack.remove(this.locationID);
        this.gv.setInput(location);
        this.gv.refresh();
        if (location instanceof Machine) {
            this.list.setText(((Machine)location).getName());
        } else if (location instanceof GTPattern) {
            this.list.setText(((GTPattern)location).getName());
        }
        this.setViewerActionEnabled();
    }

    public String getContributorId() {
        return "org.eclipse.viatra2.visualisation.view";
    }

    @Override
    public void createFormContributions(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        this.createHeaderRegion(form, toolkit);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 4;
        form.getBody().setLayout((Layout)layout);
        Section section = toolkit.createSection(form.getBody(), 4096);
        this.initializeViewer((Composite)section);
        section.setClient((Control)this.gv.getGraphControl());
    }

    private void createHeaderRegion(ScrolledForm form, FormToolkit toolkit) {
        form.setText(this.machineName);
        Composite header = new Composite(form.getForm().getHead(), 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 2;
        header.setLayout((Layout)glayout);
        header.setBackgroundMode(1);
        form.setHeadClient((Control)header);
        Label label = new Label(header, 0);
        label.setText("Element to visualise");
        this.list = new Combo(header, 12);
        toolkit.adapt((Composite)this.list);
        this.list.add(this.machineName);
        for (GTPattern pattern : this.patternStorage.values()) {
            this.list.add(pattern.getName());
        }
        this.list.setText(this.machineName);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = PatternGraphDescriptor.this.list.getText();
                if (text == null) {
                    return;
                }
                if (text.equals(PatternGraphDescriptor.this.machineName)) {
                    if (!PatternGraphDescriptor.this.gv.getInput().equals(PatternGraphDescriptor.this.machine)) {
                        PatternGraphDescriptor.this.pushItem(PatternGraphDescriptor.this.machine);
                    }
                    return;
                }
                if (PatternGraphDescriptor.this.patternStorage.containsKey(text)) {
                    GTPattern pattern = PatternGraphDescriptor.this.patternStorage.get(text);
                    if (!PatternGraphDescriptor.this.gv.getInput().equals(pattern)) {
                        PatternGraphDescriptor.this.pushItem(pattern);
                    }
                    return;
                }
            }
        });
        GridData data = new GridData();
        data.widthHint = 200;
        this.list.setLayoutData((Object)data);
        toolkit.adapt(header);
        toolkit.decorateFormHeading(form.getForm());
    }

    @Override
    public void setLayoutAlgorithm(IViatraLayoutAlgorithm algorithm) {
        for (ViewerFilter filter : this.filters) {
            this.gv.removeFilter(filter);
        }
        this.gv.setCompoundLayout(algorithm.getAlgorithm());
        for (ViewerFilter filter : this.filters) {
            this.gv.addFilter(filter);
        }
        this.gv.applyLayout();
    }

    @Override
    public void setVisualisationPreset(VisualisationPreset vp) {
        for (ViewerFilter viewerFilter : this.filters) {
            this.gv.removeFilter(viewerFilter);
        }
        this.gv.setCompoundLayout(((IViatraLayoutAlgorithm)vp.layout.element).getAlgorithm());
        this.filters.clear();
        for (NamedElement namedElement : vp.filters.filters) {
            this.gv.addFilter((ViewerFilter)namedElement.element);
            this.filters.add((ViewerFilter)namedElement.element);
        }
        this.gv.applyLayout();
        this.gv.refresh();
    }

    @Override
    public void setLabelProvider(ViatraColoredLabelProvider provider) {
        this.setLabelProvider(provider, true);
    }

    @Override
    public void setLabelProvider(ViatraColoredLabelProvider provider, boolean doRefresh) {
    }

    @Override
    public void setFilterConfiguration(FilterConfiguration fc) {
        this.setFilterConfiguration(fc, true);
    }

    @Override
    public void setFilterConfiguration(FilterConfiguration fc, boolean doRefresh) {
        for (ViewerFilter viewerFilter : this.filters) {
            this.gv.removeFilter(viewerFilter);
        }
        this.filters.clear();
        for (NamedElement namedElement : fc.filters) {
            this.gv.addFilter((ViewerFilter)namedElement.element);
            this.filters.add((ViewerFilter)namedElement.element);
        }
        this.gv.refresh();
    }

    @Override
    public void refreshGraph() {
        this.gv.refresh();
    }

    @Override
    public void redrawGraph() {
        this.gv.applyLayout();
    }
}

