/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns.actions;

import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.TransformationContent;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.patterns.PatternGraphDescriptor;
import org.eclipse.viatra2.visualisation.view.ViatraVisualisationView;

public class VisualisePatternGraphAction
extends AbstractFrameworkGUIAction {
    public VisualisePatternGraphAction() {
        this.setText("Visualise Pattern Graph");
        this.setToolTipText("Displays patterns from this machine visually.");
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        super.run();
        this.refreshSelection();
        Object c = this.getFirstSelected();
        if (c instanceof TransformationContent.MachineDummy) {
            PatternGraphDescriptor descriptor;
            Machine machine = ((TransformationContent.MachineDummy)c).getMachine();
            ViatraVisualisationView view = ViatraVisualisationView.openView();
            IVisualisationDescriptor newDescriptor = view.getDescriptor(machine);
            if (newDescriptor == null || !(newDescriptor instanceof PatternGraphDescriptor)) {
                descriptor = new PatternGraphDescriptor();
                descriptor.setMachine(machine);
            } else {
                descriptor = (PatternGraphDescriptor)newDescriptor;
            }
            view.setDescriptor(machine, descriptor);
        }
    }
}

