/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.ViatraColoredLabelProvider;
import org.eclipse.viatra2.visualisation.ViatraGraphViewer;
import org.eclipse.viatra2.visualisation.VisualisationManager;
import org.eclipse.viatra2.visualisation.VisualisationPlugin;
import org.eclipse.viatra2.visualisation.common.action.SetAutoLayoutAction;
import org.eclipse.viatra2.visualisation.common.extensions.FilterConfiguration;
import org.eclipse.viatra2.visualisation.common.extensions.VisualisationPreset;
import org.eclipse.viatra2.visualisation.common.extensions.internal.ExtensionAccess;
import org.eclipse.viatra2.visualisation.layouts.IViatraLayoutAlgorithm;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.CustomFilterGroup;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.LabelProviderGroup;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.LayoutGroup;
import org.eclipse.viatra2.visualisation.modelspace.actions.groups.PresetGroup;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;

public class ViatraVisualisationView
extends ViewPart
implements IZoomableWorkbenchPart {
    public static final String viewId = "org.eclipse.viatra2.visualisation.view";
    ViatraGraphViewer gv;
    Composite parent;
    Object descriptorSource;
    IVisualisationDescriptor descriptor;
    protected Point gvSize;
    boolean autoLayout = true;
    private ZoomContributionViewItem zoom;
    private Action clearGraph = new Action("Clear Graph"){

        public void run() {
            ViatraVisualisationView.this.descriptor.clearGraphModel();
        }
    };
    private Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            if (ViatraVisualisationView.this.descriptor != null) {
                ViatraVisualisationView.this.gv.applyLayout();
            }
        }
    };
    private Action saveFile = new Action("Save Graph as Image"){

        public void run() {
            FileDialog save = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 8192);
            save.setFilterExtensions(new String[]{"*.png"});
            save.setFilterNames(new String[]{"PNG File"});
            save.setFileName("modelspace.png");
            String filename = save.open();
            ViatraVisualisationView.this.gv.saveImage(filename, 5);
        }
    };
    private SetAutoLayoutAction autoLayoutAction;
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            if (ViatraVisualisationView.this.descriptor != null && ViatraVisualisationView.this.autoLayout) {
                ViatraVisualisationView.this.redraw();
            }
        }
    };

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    public IVisualisationDescriptor getDescriptor(Object descriptorSource) {
        return VisualisationPlugin.getVisualisationManager().getVisualisation(descriptorSource);
    }

    public IVisualisationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Object descriptorSource, IVisualisationDescriptor descriptor) {
        VisualisationManager manager = VisualisationPlugin.getVisualisationManager();
        if (this.descriptor != null) {
            this.descriptor.dispose();
            manager.unloadDescriptor(this.descriptorSource);
        }
        this.descriptorSource = descriptorSource;
        this.descriptor = descriptor;
        manager.loadDescriptor(descriptorSource, descriptor);
        this.loadVisualisationDescriptor(descriptor);
    }

    public void dispose() {
        if (this.descriptor != null) {
            this.descriptor.dispose();
            this.descriptor = null;
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (this.descriptor != null) {
            this.loadVisualisationDescriptor(this.descriptor);
        }
        parent.addControlListener(this.resizeListener);
    }

    private void loadVisualisationDescriptor(IVisualisationDescriptor descriptor) {
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.zoom != null) {
            this.zoom.dispose();
        }
        this.descriptor = descriptor;
        this.initializeGraphViewer(this.parent);
        this.initializeActions();
        this.createMenu();
        this.createToolbar();
        this.parent.layout();
    }

    private void initializeActions() {
        this.clearGraph.setImageDescriptor(VisualisationPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra2.visualisation", (String)"icons/clear.gif"));
        this.refreshGraph.setImageDescriptor(VisualisationPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra2.visualisation", (String)"icons/refresh.gif"));
        this.saveFile.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.zoom = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        this.autoLayoutAction = new SetAutoLayoutAction("Layout on resize");
        this.autoLayoutAction.setChecked(this.autoLayout);
    }

    private void initializeGraphViewer(Composite parent) {
        this.descriptor.createFormContributions(parent);
        this.gv = this.descriptor.getViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.gv);
        this.gvSize = this.gv.getControl().getSize();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.removeAll();
        this.descriptor.addToolbarContributions(mgr);
        mgr.add((IAction)this.refreshGraph);
        mgr.add((IAction)this.clearGraph);
        mgr.update(true);
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.removeAll();
        this.descriptor.addMenuContributions(mgr);
        ExtensionAccess.reInit();
        LayoutGroup layoutItems = new LayoutGroup();
        layoutItems.fillContextMenu(mgr);
        LabelProviderGroup lpg = new LabelProviderGroup();
        lpg.fillContextMenu(mgr);
        CustomFilterGroup cfg = new CustomFilterGroup();
        cfg.fillContextMenu(mgr);
        mgr.add((IContributionItem)new Separator());
        PresetGroup presetItems = new PresetGroup();
        presetItems.fillContextMenu(mgr);
        this.setVisualisationPreset(presetItems.getDefaultPreset());
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.saveFile);
        mgr.add((IAction)this.refreshGraph);
        mgr.add((IAction)this.autoLayoutAction);
        mgr.add((IAction)this.clearGraph);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)this.zoom);
    }

    public void setFocus() {
    }

    public void setProvider(IContentProvider provider) {
        this.gv.setContentProvider(provider);
        this.gv.setInput(new Object());
        this.gv.applyLayout();
    }

    public void setLayoutAlgorithm(IViatraLayoutAlgorithm algorithm) {
        this.descriptor.setLayoutAlgorithm(algorithm);
    }

    public void setVisualisationPreset(VisualisationPreset vp) {
        this.descriptor.setVisualisationPreset(vp);
    }

    public void setLabelProvider(ViatraColoredLabelProvider lp) {
        this.descriptor.setLabelProvider(lp, true);
    }

    public void setFilterConfiguration(FilterConfiguration fc) {
        this.descriptor.setFilterConfiguration(fc, true);
    }

    public void refresh() {
        if (this.gv != null) {
            this.gv.refresh();
        }
    }

    public void redraw() {
        if (this.gv != null) {
            this.gv.applyLayout();
        }
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.gv;
    }

    public Object getAdapter(Class adapter) {
        Object descriptorAdapter;
        if (this.descriptor != null && (descriptorAdapter = this.descriptor.getAdapter(adapter)) != null) {
            return descriptorAdapter;
        }
        return super.getAdapter(adapter);
    }

    public static ViatraVisualisationView openView() {
        OpenViewRunner runner = new OpenViewRunner();
        Display.getDefault().syncExec((Runnable)runner);
        return (ViatraVisualisationView)runner.getForm();
    }

    private static final class OpenViewRunner
    implements Runnable {
        IViewPart form = null;

        private OpenViewRunner() {
        }

        @Override
        public void run() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this.form = page.findView(ViatraVisualisationView.viewId);
            if (this.form == null) {
                try {
                    this.form = page.showView(ViatraVisualisationView.viewId);
                }
                catch (PartInitException partInitException) {}
            } else {
                page.bringToTop((IWorkbenchPart)this.form);
            }
        }

        public IViewPart getForm() {
            return this.form;
        }
    }
}

