/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ConvertToPlanProject
implements IObjectActionDelegate {
    private final List<IProject> selected = new ArrayList<IProject>();

    public void run(IAction action) {
        for (IProject project : this.selected) {
            if (FacetUtils.isPlanProject((IResource)project)) {
                this.removeFacetsFromProject(project);
                continue;
            }
            this.addFacetsToProject(project);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void addFacetsToProject(final IProject project) {
        IWorkspaceRunnable oper = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
                fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.plan").getDefaultVersion(), null, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(oper, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    private void removeFacetsFromProject(final IProject project) {
        IWorkspaceRunnable oper = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
                fProject.uninstallProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.plan").getDefaultVersion(), null, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(oper, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }
}

