/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.module.core.ServerModuleDelegate;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleExportUtils {
    public static IResource getOutputManifestFile(IJavaProject project) {
        try {
            IPackageFragmentRoot[] roots;
            HashSet<IPath> outputPaths = new HashSet<IPath>();
            outputPaths.add(project.getOutputLocation());
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPath location;
                IClasspathEntry cpEntry;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root != null && (cpEntry = root.getRawClasspathEntry()).getEntryKind() == 3 && (location = cpEntry.getOutputLocation()) != null) {
                    outputPaths.add(location);
                }
                ++n2;
            }
            for (IPath outputPath : outputPaths) {
                IResource manifest = BundleExportUtils.getManifestFile(outputPath, project.getProject());
                if (manifest == null) continue;
                return manifest;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static IResource getManifestFile(IPath outputLocation, IProject project) throws MalformedURLException {
        IPath path = outputLocation.append(BundleManifestCorePlugin.MANIFEST_FILE_LOCATION);
        IPath projectPath = project.getFullPath();
        IResource manifest = project.findMember(path = path.removeFirstSegments(path.matchingFirstSegments(projectPath)));
        if (manifest != null) {
            return manifest;
        }
        return null;
    }

    public static IJarExportRunnable createExportOperation(IJavaProject project, IPath jarLocation, Shell shell, List<IStatus> warnings) {
        JarPackageData jarPackage = new JarPackageData();
        jarPackage.setJarLocation(jarLocation);
        jarPackage.setExportClassFiles(true);
        jarPackage.setExportJavaFiles(false);
        jarPackage.setOverwrite(true);
        jarPackage.setExportErrors(true);
        jarPackage.setExportWarnings(true);
        jarPackage.setBuildIfNeeded(true);
        LinkedHashSet<IPackageFragmentRoot> outputFiles = new LinkedHashSet<IPackageFragmentRoot>();
        try {
            Set entries = ServerModuleDelegate.getSourceClasspathEntries((IProject)project.getProject(), (boolean)false);
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (entries.contains(root.getRawClasspathEntry())) {
                    outputFiles.add(root);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        jarPackage.setElements(outputFiles.toArray());
        BundleExportUtils.setManifestFile(project, jarPackage, shell, warnings);
        return jarPackage.createJarExportRunnable(shell);
    }

    private static void setManifestFile(IJavaProject project, JarPackageData jarPackage, Shell shell, List<IStatus> warnings) {
        IResource manifest = BundleExportUtils.getOutputManifestFile(project);
        if (manifest != null) {
            File manifestFile = manifest.getLocation().toFile();
            boolean exists = manifestFile.exists();
            if (exists) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(manifestFile));
                    int charactor = 97;
                    while (reader.ready()) {
                        charactor = (char)reader.read();
                    }
                    if (charactor != 10) {
                        warnings.add((IStatus)new Status(2, "org.eclipse.virgo.ide.export", "Manifest file for project " + project.getElementName() + " is missing a '\\n' at the end of file. The exported bundle might not work properly."));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                jarPackage.setGenerateManifest(false);
                jarPackage.setManifestLocation(manifest.getFullPath());
            } else {
                jarPackage.setGenerateManifest(true);
            }
        } else {
            jarPackage.setGenerateManifest(true);
        }
    }

    public static boolean executeExportOperation(IJarExportRunnable op, boolean reportStatus, IRunnableContext context, Shell shell, List<IStatus> warnings) {
        block5: {
            try {
                context.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block5;
                return false;
            }
        }
        IStatus status = op.getStatus();
        if ((warnings.size() > 0 || !status.isOK()) && reportStatus) {
            ArrayList<IStatus> children = new ArrayList<IStatus>();
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                children.add(child);
                ++n2;
            }
            children.addAll(warnings);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.virgo.ide.export", !status.isOK() ? status.getCode() : 2, (IStatus[])children.toArray(new Status[0]), !status.isOK() ? status.getMessage() : "There were warnings while exporting bundle project. Click Details to see more...", null);
            ErrorDialog.openError((Shell)shell, (String)"Export Warning", null, (IStatus)multiStatus);
            return !status.matches(4);
        }
        return true;
    }

    public static boolean executeWarExportOperation(IProject bundleProject, String jarName, IFolder settingsFolder) {
        WebComponentExportDataModelProvider provider = new WebComponentExportDataModelProvider();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)provider);
        provider.propertySet("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)bundleProject.getName());
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME", false);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", false);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", true);
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)settingsFolder.getRawLocation().append(jarName).toString());
        WebComponentExportOperation operation = new WebComponentExportOperation(dataModel);
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            settingsFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException executionException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }
}

