/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.ui.decoration;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainer;
import org.eclipse.virgo.ide.jdt.internal.ui.decoration.JdtUiImages;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;

public class JdtClasspathContainerElementDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private IElementChangedListener changeListener = new IElementChangedListener(){
        private static final int F_RESOLVED_CLASSPATH_CHANGED = 0x200000;

        public void elementChanged(ElementChangedEvent event) {
            boolean refresh = false;
            IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                if ((delta.getFlags() & 0x200000) != 0 || (delta.getFlags() & 0x20000) != 0) {
                    refresh = true;
                }
                ++n2;
            }
            if (refresh) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        JdtClasspathContainerElementDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)JdtClasspathContainerElementDecorator.this));
                    }
                });
            }
        }
    };

    public JdtClasspathContainerElementDecorator() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.changeListener, (int)1);
    }

    public void decorate(Object element, IDecoration decoration) {
        block20: {
            ClassPathContainer container;
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                if (this.shouldDecorateImportedPackageFragment(packageFragment)) {
                    decoration.setForegroundColor(ColorMap.GRAY_LIGHT);
                    decoration.addOverlay(JdtUiImages.DESC_OVR_LOCKED, 0);
                } else if (this.shouldDecorateExportedPackageFragment(packageFragment)) {
                    decoration.addOverlay(JdtUiImages.DESC_OVR_EXPORTED, 1);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                try {
                    ServerClasspathContainer cpContainer;
                    if (!ServerClasspathContainer.CLASSPATH_CONTAINER_PATH.equals((Object)root.getRawClasspathEntry().getPath()) || !root.getJavaProject().getProject().isAccessible() || !root.getJavaProject().isOpen() || (cpContainer = (ServerClasspathContainer)JavaCore.getClasspathContainer((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, (IJavaProject)root.getJavaProject())) == null) break block20;
                    IClasspathEntry[] iClasspathEntryArray = cpContainer.getClasspathEntries();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getPath().equals((Object)root.getPath()) && entry.getExtraAttributes() != null) {
                            IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
                            int n3 = iClasspathAttributeArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IClasspathAttribute attribute = iClasspathAttributeArray[n4];
                                if (attribute.getName().equals("org.eclipse.virgo.ide.jdt.core.TEST_CLASSPATH_ENTRY")) {
                                    decoration.setForegroundColor(ColorMap.GRAY_LIGHT);
                                    decoration.addOverlay(JdtUiImages.DESC_OVR_LOCKED, 0);
                                }
                                ++n4;
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (element instanceof IClassFile) {
                IClassFile classFile = (IClassFile)element;
                if (classFile.getParent() instanceof IPackageFragment && this.shouldDecorateImportedPackageFragment((IPackageFragment)classFile.getParent())) {
                    decoration.setForegroundColor(ColorMap.GRAY_LIGHT);
                }
            } else if (element instanceof ClassPathContainer && (container = (ClassPathContainer)element).getClasspathEntry().getPath().equals((Object)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH)) {
                try {
                    if (container.getJavaProject().getProject().isAccessible() && container.getJavaProject().isOpen()) {
                        ServerClasspathContainer cpContainer = (ServerClasspathContainer)JavaCore.getClasspathContainer((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, (IJavaProject)container.getJavaProject());
                        decoration.addSuffix(cpContainer.getDescriptionSuffix());
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    private boolean shouldDecorateExportedPackageFragment(IPackageFragment packageFragment) {
        IJavaProject lavaProject = packageFragment.getJavaProject();
        return FacetUtils.isBundleProject((IResource)lavaProject.getProject()) && BundleManifestCorePlugin.getBundleManifestManager().getPackageExports(lavaProject).contains(packageFragment.getElementName());
    }

    private boolean shouldDecorateImportedPackageFragment(IPackageFragment packageFragment) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getParent();
        IJavaProject javaProject = packageFragment.getJavaProject();
        if (!javaProject.getProject().isAccessible() || !javaProject.isOpen()) {
            return false;
        }
        if (!FacetUtils.isBundleProject((IResource)javaProject.getProject())) {
            return false;
        }
        try {
            IClasspathEntry entry = root.getRawClasspathEntry();
            if (entry.getPath().equals((Object)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH) && !BundleManifestCorePlugin.getBundleManifestManager().getResolvedPackageImports(root.getJavaProject()).contains(packageFragment.getElementName())) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        ColorMap.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.changeListener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private static class ColorMap {
        public static final Color GRAY_LIGHT = new Color((Device)Display.getDefault(), 145, 145, 145);

        private ColorMap() {
        }

        public static void dispose() {
            GRAY_LIGHT.dispose();
        }
    }
}

