/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.facet.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.virgo.ide.facet.internal.core.Artifact;
import org.eclipse.virgo.ide.facet.internal.core.BundleReference;
import org.eclipse.virgo.ide.facet.internal.core.Plan;
import org.eclipse.virgo.ide.facet.internal.core.PlanReference;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanReader {
    private static final String PLAN = "plan";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String ARTIFACT_ELEMENT = "artifact";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private static final Object BUNDLE = "bundle";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Plan read(IFile file) {
        Plan plan;
        Assert.isNotNull((Object)file, (String)"file cannot be null");
        InputStream inputStream = null;
        try {
            inputStream = file.getContents();
            Document doc = this.readDocument(inputStream);
            Element element = doc.getDocumentElement();
            plan = this.parsePlanElement(file, element);
            if (inputStream == null) return plan;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to read plan descriptor", e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return plan;
        }
        catch (IOException iOException) {}
        return plan;
    }

    private Document readDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuilderFactory().newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return builder.parse(inputStream);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XSD_SCHEMA_LANGUAGE);
        return factory;
    }

    private Plan parsePlanElement(IFile file, Element element) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        Version version = new Version(element.getAttribute(VERSION_ATTRIBUTE));
        Properties attributes = this.parseAttributes(element);
        List<Artifact> artifacts = this.parseNestedArtifacts(element.getElementsByTagName(ARTIFACT_ELEMENT), attributes);
        return new Plan(name, version, artifacts);
    }

    private Properties parseAttributes(Element element) {
        Properties result = new Properties();
        NodeList attributeElements = element.getElementsByTagName(ATTRIBUTE_ELEMENT);
        int x = 0;
        while (x < attributeElements.getLength()) {
            Element attribute = (Element)attributeElements.item(x);
            String name = attribute.getAttribute(NAME_ATTRIBUTE);
            String value = attribute.getAttribute(VALUE_ATTRIBUTE);
            result.put(name, value);
            ++x;
        }
        return result;
    }

    private List<Artifact> parseNestedArtifacts(NodeList artifactElements, Properties attributes) {
        ArrayList<Artifact> refs = new ArrayList<Artifact>();
        int i = 0;
        while (i < artifactElements.getLength()) {
            Element artifactElement = (Element)artifactElements.item(i);
            String type = artifactElement.getAttribute(TYPE_ATTRIBUTE);
            String name = artifactElement.getAttribute(NAME_ATTRIBUTE);
            String versionString = artifactElement.getAttribute(VERSION_ATTRIBUTE);
            Version version = null;
            if (versionString != null && !versionString.isEmpty()) {
                version = new Version(versionString);
            }
            if (PLAN.equals(type)) {
                refs.add(new PlanReference(name, version));
            } else if (BUNDLE.equals(type)) {
                refs.add(new BundleReference(name, version));
            }
            ++i;
        }
        return refs;
    }
}

