/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.virgo.ide.ui.wizards.Messages;

public class NewPlanProjectFilePage
extends WizardPage {
    public static final String PAGE_NAME = NewPlanProjectFilePage.class.getSimpleName();
    private String planName;
    private Label planNameLabel;
    private Text planNameText;
    private Button scoped;
    private Button atomic;

    public NewPlanProjectFilePage() {
        super(PAGE_NAME);
        this.setTitle(Messages.NewPlanProjectNamePage_title);
        this.setDescription(Messages.NewPlanProjectNamePage_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createContextRootSection(container);
        this.setControl((Control)container);
    }

    protected void createContextRootSection(Composite container) {
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        this.planNameLabel = new Label(container, 0);
        this.planNameLabel.setText(Messages.NewPlanProjectNamePage_plan_label);
        this.planNameText = new Text(container, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.planNameText);
        this.scoped = new Button(container, 32);
        this.scoped.setText(Messages.NewPlanProjectFilePage_scoped_label);
        this.scoped.setSelection(false);
        this.atomic = new Button(container, 32);
        this.atomic.setText(Messages.NewPlanProjectFilePage_atomic_label);
        this.atomic.setSelection(true);
        this.planNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPlanProjectFilePage.this.modifyText(e);
            }
        });
    }

    protected void modifyText(ModifyEvent e) {
        this.planName = null;
        String name = this.planNameText.getText();
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.setPageComplete(false);
            return;
        }
        this.planName = name;
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public String getPlanName() {
        return this.planName;
    }

    public boolean isScoped() {
        return this.scoped.getSelection();
    }

    public boolean isAtomic() {
        return this.atomic.getSelection();
    }
}

