/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiPlugin;

public class ServerUiImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.eclipse.virgo.ide.runtime.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.virgo.ide.runtime.ui.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_WIZB_SERVER = "org.eclipse.virgo.ide.runtime.ui.springsource_wiz.png";
    public static final String IMG_WIZB_VIRGO_SERVER = "org.eclipse.virgo.ide.runtime.ui.virgo_wiz.png";
    public static final String IMG_OBJ_PORT = "org.eclipse.virgo.ide.runtime.ui.port_obj.gif";
    public static final String IMG_OBJ_VIRGO = "org.eclipse.virgo.ide.runtime.ui.virgo_obj.png";
    public static final String IMG_OBJ_VIRGO_LIB = "org.eclipse.virgo.ide.runtime.ui.virgo_obj_lib.png";
    public static final String IMG_OBJ_VIRGO_FILE = "org.eclipse.virgo.ide.runtime.ui.virgo_obj_file.png";
    public static final String IMG_VIRGO_OVER = "org.eclipse.virgo.ide.runtime.ui.virgo_over.png";
    public static final String IMG_PDE_OVER = "org.eclipse.virgo.ide.runtime.ui.pde_over.png";
    public static final String IMG_OBJ_BUNDLE = "org.eclipse.virgo.ide.runtime.ui.bundle_obj.gif";
    public static final String IMG_OBJ_BUNDLE_SRC = "org.eclipse.virgo.ide.runtime.ui.bundle_src_obj.gif";
    public static final String IMG_OBJ_LIB = "org.eclipse.virgo.ide.runtime.ui.lib_obj.gif";
    public static final String IMG_OBJ_FILE = "org.eclipse.virgo.ide.runtime.ui.file_obj.gif";
    private static final String OBJECT = "obj16/";
    private static final String OVER = "over08/";
    private static final String WIZBAN = "wizban/";
    public static final ImageDescriptor DESC_WIZB_SERVER;
    public static final ImageDescriptor DESC_WIZB_VIRGO_SERVER;
    public static final ImageDescriptor DESC_OBJ_VIRGO_LIB;
    public static final ImageDescriptor DESC_OBJ_VIRGO_FILE;
    public static final ImageDescriptor DESC_OBJ_VIRGO_OVER;
    public static final ImageDescriptor DESC_OBJ_PDE_OVER;
    public static final ImageDescriptor DESC_OBJ_PORT;
    public static final ImageDescriptor DESC_OBJ_VIRGO;
    public static final ImageDescriptor DESC_OBJ_BUNDLE;
    public static final ImageDescriptor DESC_OBJ_BUNDLE_SRC;
    public static final ImageDescriptor DESC_OBJ_LIB;
    public static final ImageDescriptor DESC_OBJ_FILE;

    static {
        try {
            ICON_BASE_URL = new URL(ServerUiPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            ServerUiPlugin.log(e);
        }
        DESC_WIZB_SERVER = ServerUiImages.createManaged(WIZBAN, IMG_WIZB_SERVER);
        DESC_WIZB_VIRGO_SERVER = ServerUiImages.createManaged(WIZBAN, IMG_WIZB_VIRGO_SERVER);
        DESC_OBJ_VIRGO_LIB = ServerUiImages.createManaged(OBJECT, IMG_OBJ_VIRGO_LIB);
        DESC_OBJ_VIRGO_FILE = ServerUiImages.createManaged(OBJECT, IMG_OBJ_VIRGO_FILE);
        DESC_OBJ_VIRGO_OVER = ServerUiImages.createManaged(OVER, IMG_OBJ_VIRGO);
        DESC_OBJ_PDE_OVER = ServerUiImages.createManaged(OVER, IMG_PDE_OVER);
        DESC_OBJ_PORT = ServerUiImages.createManaged(OBJECT, IMG_OBJ_PORT);
        DESC_OBJ_VIRGO = ServerUiImages.createManaged(OBJECT, IMG_OBJ_VIRGO);
        DESC_OBJ_BUNDLE = ServerUiImages.createManaged(OBJECT, IMG_OBJ_BUNDLE);
        DESC_OBJ_BUNDLE_SRC = ServerUiImages.createManaged(OBJECT, IMG_OBJ_BUNDLE_SRC);
        DESC_OBJ_LIB = ServerUiImages.createManaged(OBJECT, IMG_OBJ_LIB);
        DESC_OBJ_FILE = ServerUiImages.createManaged(OBJECT, IMG_OBJ_FILE);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return ServerUiPlugin.getDefault().getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        ServerUiImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        ServerUiImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        action.setImageDescriptor(ServerUiImages.create("e" + type, relPath));
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)ServerUiImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            ServerUiPlugin.log(e);
        }
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)ServerUiImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            ServerUiPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)ServerUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            ServerUiPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

