/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.core.CreatePlanProjectOperation;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.wizards.Messages;
import org.eclipse.virgo.ide.ui.wizards.NewPlanProjectFilePage;

public class NewPlanProjectWizard
extends NewWizard {
    WizardNewProjectCreationPage mainPage;
    private NewPlanProjectFilePage planPage;

    public NewPlanProjectWizard() {
        this.setWindowTitle(Messages.NewPlanProjectWizard_title);
        this.setDefaultPageImageDescriptor(ServerIdeUiPlugin.getImageDescriptor("full/wizban/wizban-par.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("planPage");
        this.mainPage.setTitle(Messages.NewPlanProjectNamePage_title);
        this.mainPage.setDescription(Messages.NewPlanProjectNamePage_description);
        this.addPage((IWizardPage)this.mainPage);
        this.planPage = new NewPlanProjectFilePage();
        this.addPage((IWizardPage)this.planPage);
    }

    public boolean performFinish() {
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        String name = this.planPage.getPlanName();
        boolean atomic = this.planPage.isAtomic();
        boolean scoped = this.planPage.isScoped();
        final CreatePlanProjectOperation operation = new CreatePlanProjectOperation(this.mainPage.getProjectHandle(), location, name, scoped, atomic, this.getShell());
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 3);
                    }
                }
            });
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)s, 3);
        }
        IFile file = operation.getPlanFile();
        if (file != null) {
            IEditorDescriptor editorDesc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId());
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return true;
    }
}

