/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleConfigurationConvertor {
    private final Logger logger;
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private ServiceRegistration<ManagedService> configuratorRegistration;
    private static final String CONSOLE_PID = "osgi.console";
    private static final String TELNET_PID = "osgi.console.telnet";
    private static final String SSH_PID = "osgi.console.ssh";
    private static final String TELNET_PORT = "telnet.port";
    private static final String TELNET_HOST = "telnet.host";
    private static final String TELNET_ENABLED = "telnet.enabled";
    private static final String SSH_PORT = "ssh.port";
    private static final String SSH_HOST = "ssh.host";
    private static final String SSH_ENABLED = "ssh.enabled";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ENABLED = "enabled";
    private static final String TELNET_SERVICE = "telnet";
    private static final String SSH_SERVICE = "ssh";
    private static final Object monitor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("ConsoleConfigurationConvertor.java", Class.forName("org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "", "", "", "void"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateConfiguration", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "pid:host:port:enabled:", "", "void"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "", "", "", "void"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteConfiguration", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "java.lang.String:", "pid:", "", "void"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPortAvailability", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "java.lang.String:java.lang.String:java.lang.String:", "portStr:enabled:service:", "", "boolean"), 125);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "", "", "", "java.lang.Object"), 69);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor:", "arg0:", "", "org.osgi.framework.ServiceRegistration"), 39);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor:java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "arg0:arg1:arg2:arg3:arg4:", "", "void"), 84);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor");
        monitor = new Object();
    }

    ConsoleConfigurationConvertor(BundleContext context, ConfigurationAdmin configAdmin) {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.context = context;
            this.configAdmin = configAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                Hashtable<String, String> consoleProperties = new Hashtable<String, String>();
                ((Dictionary)consoleProperties).put("service.pid", CONSOLE_PID);
                Object object = monitor;
                synchronized (object) {
                    this.configuratorRegistration = this.context.registerService(ManagedService.class, (Object)new ConsoleConfigurator(), consoleProperties);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void updateConfiguration(String pid, String host, String port, String enabled) {
        try {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                boolean isPortAvailable = pid.contains(TELNET_SERVICE) ? this.checkPortAvailability(port, enabled, TELNET_SERVICE) : this.checkPortAvailability(port, enabled, SSH_SERVICE);
                if (isPortAvailable) {
                    try {
                        Configuration configuration = this.configAdmin.getConfiguration(pid, null);
                        Hashtable<String, String> properties = new Hashtable<String, String>();
                        ((Dictionary)properties).put(HOST, host);
                        ((Dictionary)properties).put(PORT, port);
                        ((Dictionary)properties).put(ENABLED, enabled);
                        configuration.update(properties);
                    }
                    catch (IOException e) {
                        String message = String.format("Unable to update configuration with pid '%s'", pid);
                        this.logger.error(message, (Throwable)e);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public void stop() {
        try {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            try {
                this.deleteConfiguration(TELNET_PID);
                this.deleteConfiguration(SSH_PID);
                this.deleteConfiguration(CONSOLE_PID);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void deleteConfiguration(String pid) {
        try {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                try {
                    Configuration configuration = this.configAdmin.getConfiguration(pid, null);
                    configuration.delete();
                }
                catch (IOException e) {
                    String message = String.format("Unable to delete configuration with pid: " + pid, new Object[0]);
                    this.logger.error(message, (Throwable)e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkPortAvailability(String portStr, String enabled, String service) {
        try {
            block22: {
                ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf().ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ConsoleConfigurationConvertor.ajc$tjp_4);
                try {
                    block23: {
                        if ("false".equalsIgnoreCase(enabled)) {
                            var10_4 = true;
                            break block22;
                        }
                        port = Integer.parseInt(portStr);
                        socket = null;
                        socket = new ServerSocket(port);
                        if (socket == null) break block23;
                        try {
                            socket.close();
                        }
                        catch (IOException v0) {}
                    }
                    var10_4 = true;
                    break block22;
                    catch (BindException e) {
                        message = "Port " + port + " already in use; " + service + " access to console will not be available";
                        this.logger.error(message, (Throwable)e);
                        ** if (socket == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                socket.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (IOException v2) {
                        ** if (socket == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                socket.close();
                            }
                            catch (IOException v3) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        {
                            catch (Throwable var8_9) {
                                if (socket != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException v4) {}
                                }
                                throw var8_9;
                            }
                        }
                    }
                    var10_4 = false;
                }
                catch (RuntimeException var9_10) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(var9_10);
                    throw var9_10;
                }
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf().ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ConsoleConfigurationConvertor.ajc$tjp_4);
            return var10_4;
        }
        catch (Throwable var11_11) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf().ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(var11_11, ConsoleConfigurationConvertor.ajc$tjp_4);
            throw var11_11;
        }
    }

    static /* synthetic */ Object access$0() {
        try {
            Object object;
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            try {
                object = monitor;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return object;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    static /* synthetic */ ServiceRegistration access$1(ConsoleConfigurationConvertor arg0) {
        try {
            ServiceRegistration<ManagedService> serviceRegistration;
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                serviceRegistration = arg0.configuratorRegistration;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return serviceRegistration;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    static /* synthetic */ void access$2(ConsoleConfigurationConvertor arg0, String arg1, String arg2, String arg3, String arg4) {
        try {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                arg0.updateConfiguration(arg1, arg2, arg3, arg4);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            ConsoleConfigurationConvertor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    class ConsoleConfigurator
    implements ManagedService {
        private Dictionary properties;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        ConsoleConfigurator() {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(Dictionary props) throws ConfigurationException {
            try {
                block7: {
                    ConsoleConfigurator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    try {
                        if (props == null) break block7;
                        this.properties = props;
                        this.properties.put("service.pid", ConsoleConfigurationConvertor.CONSOLE_PID);
                        Object object = ConsoleConfigurationConvertor.access$0();
                        synchronized (object) {
                            ConsoleConfigurationConvertor.access$1(ConsoleConfigurationConvertor.this).setProperties(this.properties);
                        }
                        String telnetHost = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_HOST);
                        String telnetPort = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_PORT);
                        String telnetEnabled = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_ENABLED);
                        ConsoleConfigurationConvertor.access$2(ConsoleConfigurationConvertor.this, ConsoleConfigurationConvertor.TELNET_PID, telnetHost, telnetPort, telnetEnabled);
                        String sshHost = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_HOST);
                        String sshPort = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_PORT);
                        String sshEnabled = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_ENABLED);
                        ConsoleConfigurationConvertor.access$2(ConsoleConfigurationConvertor.this, ConsoleConfigurationConvertor.SSH_PID, sshHost, sshPort, sshEnabled);
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }
                ConsoleConfigurator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ConsoleConfigurator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("ConsoleConfigurationConvertor.java", Class.forName("org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor$ConsoleConfigurator"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updated", "org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor$ConsoleConfigurator", "java.util.Dictionary:", "props:", "org.osgi.service.cm.ConfigurationException:", "void"), 156);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.ConsoleConfigurationConvertor$ConsoleConfigurator");
        }
    }
}

