/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.MethodInvokingRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Object scheduler;
    private final ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
    private final Map<Runnable, String> cronTasks = new HashMap<Runnable, String>();
    private final Map<Runnable, Long> fixedDelayTasks = new HashMap<Runnable, Long>();
    private final Map<Runnable, Long> fixedRateTasks = new HashMap<Runnable, Long>();

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (targetClass == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Scheduled annotation = (Scheduled)AnnotationUtils.getAnnotation((Method)method, Scheduled.class);
                if (annotation != null) {
                    long fixedRate;
                    long fixedDelay;
                    Assert.isTrue((boolean)Void.TYPE.equals(method.getReturnType()), (String)"Only void-returning methods may be annotated with @Scheduled.");
                    Assert.isTrue((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled.");
                    MethodInvokingRunnable runnable = new MethodInvokingRunnable();
                    runnable.setTargetObject(bean);
                    runnable.setTargetMethod(method.getName());
                    runnable.setArguments(new Object[0]);
                    try {
                        runnable.prepare();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("failed to prepare task", e);
                    }
                    boolean processedSchedule = false;
                    String errorMessage = "Exactly one of 'cron', 'fixedDelay', or 'fixedRate' is required.";
                    String cron = annotation.cron();
                    if (!"".equals(cron)) {
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.cronTasks.put(runnable, cron);
                    }
                    if ((fixedDelay = annotation.fixedDelay()) >= 0L) {
                        Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedDelayTasks.put(runnable, new Long(fixedDelay));
                    }
                    if ((fixedRate = annotation.fixedRate()) >= 0L) {
                        Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedRateTasks.put(runnable, new Long(fixedRate));
                    }
                    Assert.isTrue((boolean)processedSchedule, (String)errorMessage);
                }
            }
        });
        return bean;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        this.registrar.setCronTasks(this.cronTasks);
        this.registrar.setFixedDelayTasks(this.fixedDelayTasks);
        this.registrar.setFixedRateTasks(this.fixedRateTasks);
        this.registrar.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        if (this.registrar != null) {
            this.registrar.destroy();
        }
    }
}

