/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.virgo.kernel.osgicommand.helper.ClassLoadingHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GogoClassLoadingCommand {
    private BundleContext bundleContext;

    public GogoClassLoadingCommand(BundleContext context) {
        this.bundleContext = context;
    }

    @Descriptor(value="list all bundles that contain a class or resource with the specified name")
    public void clhas(@Descriptor(value="class or resource name") String className) {
        Map<Bundle, List<String>> foundBundles = ClassLoadingHelper.getBundlesContainingResource(this.bundleContext, className = ClassLoadingHelper.convertToResourcePath(className));
        if (foundBundles.size() == 0) {
            System.out.println("No bundle contains [" + className + "]");
            return;
        }
        this.outputBundlesAndResources("Bundles containing [" + className + "]:", foundBundles);
    }

    @Descriptor(value="list all bundles that can load the specified class")
    public void clload(@Descriptor(value="fully qualified class name") String className) {
        this.doClload(className, null);
    }

    @Descriptor(value="try to load the specified class using the specified bundle")
    public void clload(@Descriptor(value="fully qualified class name") String className, @Descriptor(value="bundle symbolic name") String bundleName) {
        this.doClload(className, bundleName);
    }

    @Descriptor(value="try to load the specified class using the specified bundle")
    public void clload(@Descriptor(value="fully qualified class name") String className, @Descriptor(value="  bundle id") long bundleId) {
        this.doClload(className, String.valueOf(bundleId));
    }

    private void doClload(String className, String bundle) {
        Map<Bundle, Bundle> foundBundles;
        if (this.extractPackage(className) == null) {
            System.out.println("Warning: the class name [" + className + "] has no package and is assumed to belong to the default package");
        }
        if ((foundBundles = bundle == null ? ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className) : ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className, bundle)).size() == 0) {
            if (bundle == null) {
                System.out.println("No bundle can load class [" + className + "]");
            } else {
                System.out.println("Bundle [" + bundle + "] cannot load class [" + className + "]");
            }
            return;
        }
        this.outputFoundBundlesAndRelations("Successfully loaded [" + className + "] " + (bundle != null ? "using class loader from:" : "from:"), foundBundles, "provided by");
    }

    @Descriptor(value="list all bundles that export a class with the specified name")
    public void clexport(@Descriptor(value="fully qualified class name") String className) {
        String classPackage = this.extractPackage(className);
        if (classPackage == null) {
            System.out.println("The class name [" + className + "] contains no package");
            return;
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        HashMap<Long, String> foundBundles = new HashMap<Long, String>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (ClassLoadingHelper.isPackageExported(this.bundleContext, classPackage, bundle)) {
                if (ClassLoadingHelper.tryToLoadClass(className, bundle) != null) {
                    foundBundles.put(bundle.getBundleId(), bundle.getSymbolicName());
                } else {
                    foundBundles.put(bundle.getBundleId(), String.valueOf(bundle.getSymbolicName()) + "     [class not found, package only]");
                }
            }
            ++n2;
        }
        if (foundBundles.size() == 0) {
            System.out.println("No bundle exports class [" + className + "]");
            return;
        }
        System.out.println();
        System.out.println("Bundles exporting [" + className + "]:");
        for (Map.Entry entry : foundBundles.entrySet()) {
            System.out.println("  " + entry.getKey() + "\t" + (String)entry.getValue());
        }
    }

    private String extractPackage(String className) {
        int index = className.lastIndexOf(".");
        return index == -1 ? null : className.substring(0, index);
    }

    private void outputFoundBundlesAndRelations(String message, Map<Bundle, Bundle> foundBundles, String relation) {
        System.out.println();
        System.out.println(message);
        for (Map.Entry<Bundle, Bundle> entry : foundBundles.entrySet()) {
            Bundle originalBundle;
            Bundle testBundle = entry.getKey();
            if (testBundle.equals(originalBundle = entry.getValue())) {
                System.out.println("  " + this.bundleToString(testBundle, false));
                continue;
            }
            System.out.println("  " + this.bundleToString(testBundle, false));
            if (relation == null) continue;
            System.out.println("  \t\t[" + relation + " " + this.bundleToString(originalBundle, true) + "]");
        }
    }

    private void outputBundlesAndResources(String message, Map<Bundle, List<String>> foundBundles) {
        System.out.println();
        System.out.println(message);
        for (Map.Entry<Bundle, List<String>> bundleListEntry : foundBundles.entrySet()) {
            System.out.println("  " + this.bundleToString(bundleListEntry.getKey(), false));
            for (String resource : bundleListEntry.getValue()) {
                System.out.println("  \t\t" + resource);
            }
        }
    }

    private String bundleToString(Bundle b, boolean space) {
        return String.valueOf(b.getBundleId()) + (space ? " " : "\t") + b.getSymbolicName();
    }
}

