/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.NanoDeployerLogEvents;
import org.eclipse.virgo.nano.deployer.SimpleDeployer;
import org.eclipse.virgo.nano.deployer.StandardDeploymentIdentity;
import org.eclipse.virgo.nano.deployer.util.BundleInfosUpdater;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.parse.BundleManifestParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDeployer
implements SimpleDeployer {
    private static final String JAR = "jar";
    private static final boolean STATUS_ERROR = false;
    private static final boolean STATUS_OK = true;
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final String FILE_PROTOCOL = "file";
    private static final String UNKNOWN = "unknown";
    private static final String INSTALL_BY_REFERENCE_PREFIX = "reference:file:";
    private final EventLogger eventLogger;
    private final long largeFileCopyTimeout = 30000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final BundleInfosUpdater bundleInfosUpdater;
    private final PackageAdmin packageAdmin;
    private final File workBundleInstallLocation;

    public BundleDeployer(BundleContext bundleContext, PackageAdmin packageAdmin, EventLogger eventLogger) {
        this.eventLogger = eventLogger;
        this.bundleContext = bundleContext;
        this.packageAdmin = packageAdmin;
        String kernelHome = System.getProperty("org.eclipse.virgo.kernel.home");
        File kernelHomeFile = new File(kernelHome);
        File bundlesInfoFile = new File(kernelHomeFile, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.bundleInfosUpdater = new BundleInfosUpdater(bundlesInfoFile, kernelHomeFile);
        String thisBundleName = this.bundleContext.getBundle().getSymbolicName();
        String staging = "staging";
        this.workBundleInstallLocation = new File(kernelHomeFile, "work" + File.separator + thisBundleName + File.separator + staging);
    }

    @Override
    public boolean deploy(URI path) {
        File deployedFile;
        block14: {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(path).toString()});
            deployedFile = new File(path);
            if (!this.canWrite(path)) {
                this.logger.error("Cannot open the file " + path + " for writing. The configured timeout is " + 30000L + ".");
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
                return false;
            }
            try {
                if (this.workBundleInstallLocation.exists() || this.workBundleInstallLocation.mkdirs()) break block14;
                this.logger.error("Failed to create staging directory '" + this.workBundleInstallLocation.getAbsolutePath() + "' for bundle deployment.");
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
                return false;
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{path});
                return false;
            }
        }
        File stagedFile = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(path.toString()));
        FileCopyUtils.copy((File)deployedFile, (File)stagedFile);
        Bundle installed = this.bundleContext.installBundle(this.createInstallLocation(stagedFile));
        FragmentHost hostHolder = this.getFragmentHostFromDeployedBundleIfExsiting(stagedFile);
        this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        if (hostHolder != null && hostHolder.getBundleSymbolicName() != null) {
            try {
                Bundle[] hosts = this.packageAdmin.getBundles(hostHolder.getBundleSymbolicName(), null);
                if (hosts != null) {
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHING_HOST, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                    this.packageAdmin.refreshPackages(hosts);
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHED_HOST, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                }
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESH_HOST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            }
        } else {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            try {
                installed.start();
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                return false;
            }
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        }
        try {
            if (this.bundleInfosUpdater != null && this.bundleInfosUpdater.isAvailable()) {
                this.registerToBundlesInfo(installed, hostHolder != null && hostHolder.getBundleSymbolicName() != null);
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        }
        return true;
    }

    private FragmentHost getFragmentHostFromDeployedBundleIfExsiting(File stagedFile) {
        try {
            JarFile bundleJar = new JarFile(stagedFile);
            BundleManifest manifest = BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(bundleJar.getInputStream(bundleJar.getEntry("META-INF/MANIFEST.MF"))));
            return manifest.getFragmentHost();
        }
        catch (IOException ioe) {
            this.logger.error("Failed to extract the fragment host header from file '" + stagedFile.getAbsolutePath() + "'.", (Throwable)ioe);
            return null;
        }
        catch (BundleManifestParseException bundleManifestParseException) {
            return null;
        }
    }

    @Override
    public boolean update(URI path) {
        File updatedFile = new File(path);
        File matchingStagedFile = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(path.toString()));
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file [" + path + "] for writing. Timeout is [" + 30000L + "].");
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATING_ERROR, new Object[]{path});
            return false;
        }
        Bundle bundle = this.bundleContext.getBundle(this.createInstallLocation(matchingStagedFile));
        if (bundle != null) {
            try {
                FileCopyUtils.copy((File)updatedFile, (File)matchingStagedFile);
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                bundle.update();
                if (this.packageAdmin != null) {
                    this.packageAdmin.refreshPackages(new Bundle[]{bundle});
                    this.logger.info("Update of file with path '" + path + "' is successful.");
                }
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATE_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            }
        } else {
            this.deploy(path);
        }
        return true;
    }

    @Override
    public boolean undeploy(Bundle bundle) {
        if (bundle != null) {
            File stagingFileToDelete = new File(bundle.getLocation().substring(INSTALL_BY_REFERENCE_PREFIX.length()));
            FragmentHost hostHolder = this.getFragmentHostFromDeployedBundleIfExsiting(stagingFileToDelete);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Removing bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                }
                if (this.bundleInfosUpdater != null && this.bundleInfosUpdater.isAvailable()) {
                    this.unregisterToBundlesInfo(bundle, hostHolder != null && hostHolder.getBundleSymbolicName() != null);
                    this.logger.info("Successfully removed bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                } else {
                    this.logger.error("BundleInfosUpdater not available. Failed to remove bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to unregister bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "'", (Throwable)e);
            }
            try {
                if (hostHolder == null) {
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STOPPING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                    bundle.stop();
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STOPPED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                }
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNINSTALLING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                bundle.uninstall();
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNINSTALLED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                if (!stagingFileToDelete.delete()) {
                    this.logger.warn("Could not delete staging file '" + stagingFileToDelete.getAbsolutePath() + "'");
                }
            }
            catch (BundleException e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNDEPLOY_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canServeFileType(String fileType) {
        return JAR.equals(fileType);
    }

    @Override
    public boolean isDeployed(URI path) {
        File matchingStagingBundle = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(path.toString()));
        return this.bundleContext.getBundle(this.createInstallLocation(matchingStagingBundle)) != null;
    }

    @Override
    public DeploymentIdentity getDeploymentIdentity(URI path) {
        File matchingStagingBundle = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(path.toString()));
        Bundle bundle = this.bundleContext.getBundle(this.createInstallLocation(matchingStagingBundle));
        if (bundle == null) {
            return null;
        }
        return new StandardDeploymentIdentity(JAR, bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    private boolean canWrite(URI path) {
        int tries = -1;
        boolean isWritable = false;
        long timeout = 30000L / 500L;
        while ((long)tries < timeout) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(path));
                isWritable = true;
            }
            catch (FileNotFoundException e) {
                block7: {
                    try {
                        if (!this.logger.isInfoEnabled()) break block7;
                        this.logger.info("File is still locked.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)fis);
            }
            IOUtils.closeQuietly((Closeable)fis);
            break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException occurred.", (Throwable)e);
            }
            ++tries;
        }
        return isWritable;
    }

    private final void registerToBundlesInfo(Bundle bundle, boolean isFragment) throws URISyntaxException, IOException, BundleException {
        String symbolicName;
        String location = bundle.getLocation().replace('\\', '/');
        String scheme = new URI(location = location.replaceAll(" ", "%20")).getScheme();
        if (scheme != null && !scheme.equals(FILE_PROTOCOL)) {
            location = new URI(location).getRawSchemeSpecificPart();
        }
        this.bundleInfosUpdater.addBundleToBundlesInfo((symbolicName = bundle.getSymbolicName()) == null ? UNKNOWN : symbolicName, new URI(location), bundle.getVersion().toString(), 5, !isFragment);
        this.bundleInfosUpdater.updateBundleInfosRepository();
    }

    private final void unregisterToBundlesInfo(Bundle bundle, boolean isFragment) throws IOException, BundleException, URISyntaxException {
        String symbolicName;
        String location = bundle.getLocation().replace('\\', '/');
        String scheme = new URI(location = location.replaceAll(" ", "%20")).getScheme();
        if (scheme != null && !scheme.equals(FILE_PROTOCOL)) {
            location = new URI(location).getRawSchemeSpecificPart();
        }
        this.bundleInfosUpdater.removeBundleFromBundlesInfo((symbolicName = bundle.getSymbolicName()) == null ? UNKNOWN : symbolicName, new URI(location), bundle.getVersion().toString(), 5, !isFragment);
        this.bundleInfosUpdater.updateBundleInfosRepository();
    }

    private String createInstallLocation(File jarFile) {
        return INSTALL_BY_REFERENCE_PREFIX + jarFile.getAbsolutePath();
    }

    private String extractJarFileNameFromString(String path) {
        String warName = path.substring(path.lastIndexOf(47) + 1);
        return warName;
    }

    @Override
    public boolean isDeployFileValid(File file) {
        try {
            new JarFile(file);
        }
        catch (IOException iOException) {
            this.logger.error("The deployed file '" + file.getAbsolutePath() + "' is an invalid zip file.");
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAcceptedFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(JAR);
        return types;
    }
}

