/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.JarScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class AnnotationParser {
    private static final Logger LOG = Log.getLogger(AnnotationParser.class);
    protected List<String> _parsedClassNames = new ArrayList<String>();
    protected Map<String, List<DiscoverableAnnotationHandler>> _annotationHandlers = new HashMap<String, List<DiscoverableAnnotationHandler>>();
    protected List<ClassHandler> _classHandlers = new ArrayList<ClassHandler>();
    protected List<MethodHandler> _methodHandlers = new ArrayList<MethodHandler>();
    protected List<FieldHandler> _fieldHandlers = new ArrayList<FieldHandler>();

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }

    public void registerAnnotationHandler(String annotationName, DiscoverableAnnotationHandler handler) {
        List<DiscoverableAnnotationHandler> handlers = this._annotationHandlers.get(annotationName);
        if (handlers == null) {
            handlers = new ArrayList<DiscoverableAnnotationHandler>();
            this._annotationHandlers.put(annotationName, handlers);
        }
        handlers.add(handler);
    }

    public List<DiscoverableAnnotationHandler> getAnnotationHandlers(String annotationName) {
        List<DiscoverableAnnotationHandler> handlers = this._annotationHandlers.get(annotationName);
        if (handlers == null) {
            return Collections.emptyList();
        }
        return new ArrayList<DiscoverableAnnotationHandler>();
    }

    public List<DiscoverableAnnotationHandler> getAnnotationHandlers() {
        ArrayList<DiscoverableAnnotationHandler> allHandlers = new ArrayList<DiscoverableAnnotationHandler>();
        for (List<DiscoverableAnnotationHandler> list : this._annotationHandlers.values()) {
            allHandlers.addAll(list);
        }
        return allHandlers;
    }

    public void registerClassHandler(ClassHandler handler) {
        this._classHandlers.add(handler);
    }

    public boolean isParsed(String className) {
        return this._parsedClassNames.contains(className);
    }

    public void parse(String className, ClassNameResolver resolver) throws Exception {
        if (className == null) {
            return;
        }
        if (!(resolver.isExcluded(className) || this.isParsed(className) && !resolver.shouldOverride(className))) {
            className = className.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)className, (boolean)false);
            if (resource != null) {
                Resource r = Resource.newResource((URL)resource);
                this.scanClass(r.getInputStream());
            }
        }
    }

    public void parse(Class clazz, ClassNameResolver resolver, boolean visitSuperClasses) throws Exception {
        Class cz = clazz;
        while (cz != null) {
            if (!(resolver.isExcluded(cz.getName()) || this.isParsed(cz.getName()) && !resolver.shouldOverride(cz.getName()))) {
                String nameAsResource = cz.getName().replace('.', '/') + ".class";
                URL resource = Loader.getResource(this.getClass(), (String)nameAsResource, (boolean)false);
                if (resource != null) {
                    Resource r = Resource.newResource((URL)resource);
                    this.scanClass(r.getInputStream());
                }
            }
            if (visitSuperClasses) {
                cz = cz.getSuperclass();
                continue;
            }
            cz = null;
        }
    }

    public void parse(String[] classNames, ClassNameResolver resolver) throws Exception {
        if (classNames == null) {
            return;
        }
        this.parse(Arrays.asList(classNames), resolver);
    }

    public void parse(List<String> classNames, ClassNameResolver resolver) throws Exception {
        for (String s : classNames) {
            if (resolver != null && (resolver.isExcluded(s) || this.isParsed(s) && !resolver.shouldOverride(s))) continue;
            s = s.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)s, (boolean)false);
            if (resource == null) continue;
            Resource r = Resource.newResource((URL)resource);
            this.scanClass(r.getInputStream());
        }
    }

    public void parse(Resource dir, ClassNameResolver resolver) throws Exception {
        if (!dir.isDirectory() || !dir.exists()) {
            return;
        }
        String[] files = dir.list();
        for (int f = 0; files != null && f < files.length; ++f) {
            try {
                String name;
                Resource res = dir.addPath(files[f]);
                if (res.isDirectory()) {
                    this.parse(res, resolver);
                }
                if (!(name = res.getName()).endsWith(".class") || resolver != null && (resolver.isExcluded(name) || this.isParsed(name) && !resolver.shouldOverride(name))) continue;
                Resource r = Resource.newResource((URL)res.getURL());
                this.scanClass(r.getInputStream());
                continue;
            }
            catch (Exception ex) {
                LOG.warn("EXCEPTION ", (Throwable)ex);
            }
        }
    }

    public void parse(ClassLoader loader, boolean visitParents, boolean nullInclusive, final ClassNameResolver resolver) throws Exception {
        if (loader == null) {
            return;
        }
        if (!(loader instanceof URLClassLoader)) {
            return;
        }
        JarScanner scanner = new JarScanner(){

            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    String name = entry.getName();
                    if (name.toLowerCase().endsWith(".class")) {
                        String shortName = name.replace('/', '.').substring(0, name.length() - 6);
                        if (resolver == null || !resolver.isExcluded(shortName) && (!AnnotationParser.this.isParsed(shortName) || resolver.shouldOverride(shortName))) {
                            Resource clazz = Resource.newResource((String)("jar:" + jarUri + "!/" + name));
                            AnnotationParser.this.scanClass(clazz.getInputStream());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Problem processing jar entry " + entry, (Throwable)e);
                }
            }
        };
        scanner.scan(null, loader, nullInclusive, visitParents);
    }

    public void parse(URI[] uris, final ClassNameResolver resolver) throws Exception {
        if (uris == null) {
            return;
        }
        JarScanner scanner = new JarScanner(){

            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    String name = entry.getName();
                    if (name.toLowerCase().endsWith(".class")) {
                        String shortName = name.replace('/', '.').substring(0, name.length() - 6);
                        if (resolver == null || !resolver.isExcluded(shortName) && (!AnnotationParser.this.isParsed(shortName) || resolver.shouldOverride(shortName))) {
                            Resource clazz = Resource.newResource((String)("jar:" + jarUri + "!/" + name));
                            AnnotationParser.this.scanClass(clazz.getInputStream());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Problem processing jar entry " + entry, (Throwable)e);
                }
            }
        };
        scanner.scan(null, uris, true);
    }

    public void parse(URI uri, ClassNameResolver resolver) throws Exception {
        if (uri == null) {
            return;
        }
        URI[] uris = new URI[]{uri};
        this.parse(uris, resolver);
    }

    protected void scanClass(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        reader.accept((ClassVisitor)new MyClassVisitor(), 7);
    }

    public class MyClassVisitor
    extends EmptyVisitor {
        String _className;
        int _access;
        String _signature;
        String _superName;
        String[] _interfaces;
        int _version;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this._className = AnnotationParser.normalize(name);
            this._access = access;
            this._signature = signature;
            this._superName = superName;
            this._interfaces = interfaces;
            this._version = version;
            AnnotationParser.this._parsedClassNames.add(this._className);
            String[] normalizedInterfaces = null;
            if (interfaces != null) {
                normalizedInterfaces = new String[interfaces.length];
                int i = 0;
                for (String s : interfaces) {
                    normalizedInterfaces[i++] = AnnotationParser.normalize(s);
                }
            }
            for (ClassHandler h : AnnotationParser.this._classHandlers) {
                h.handle(this._className, this._version, this._access, this._signature, AnnotationParser.normalize(this._superName), normalizedInterfaces);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    List<DiscoverableAnnotationHandler> handlers = AnnotationParser.this._annotationHandlers.get(this._annotationName);
                    if (handlers != null) {
                        for (DiscoverableAnnotationHandler h : handlers) {
                            h.handleClass(MyClassVisitor.this._className, MyClassVisitor.this._version, MyClassVisitor.this._access, MyClassVisitor.this._signature, MyClassVisitor.this._superName, MyClassVisitor.this._interfaces, this._annotationName, this._annotationValues);
                        }
                    }
                }
            };
            return visitor;
        }

        public MethodVisitor visitMethod(final int access, final String name, final String methodDesc, final String signature, final String[] exceptions) {
            return new EmptyVisitor(){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            List<DiscoverableAnnotationHandler> handlers = AnnotationParser.this._annotationHandlers.get(this._annotationName);
                            if (handlers != null) {
                                for (DiscoverableAnnotationHandler h : handlers) {
                                    h.handleMethod(MyClassVisitor.this._className, name, access, methodDesc, signature, exceptions, this._annotationName, this._annotationValues);
                                }
                            }
                        }
                    };
                    return visitor;
                }
            };
        }

        public FieldVisitor visitField(final int access, final String fieldName, final String fieldType, final String signature, final Object value) {
            return new EmptyVisitor(){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            List<DiscoverableAnnotationHandler> handlers = AnnotationParser.this._annotationHandlers.get(this._annotationName);
                            if (handlers != null) {
                                for (DiscoverableAnnotationHandler h : handlers) {
                                    h.handleField(MyClassVisitor.this._className, fieldName, access, fieldType, signature, value, this._annotationName, this._annotationValues);
                                }
                            }
                        }
                    };
                    return visitor;
                }
            };
        }
    }

    public class MyAnnotationVisitor
    implements AnnotationVisitor {
        List<Value> _annotationValues;
        String _annotationName;

        public MyAnnotationVisitor(String annotationName, List<Value> values) {
            this._annotationValues = values;
            this._annotationName = annotationName;
        }

        public List<Value> getAnnotationValues() {
            return this._annotationValues;
        }

        public void visit(String aname, Object avalue) {
            SimpleValue v = new SimpleValue(aname);
            v.setValue(avalue);
            this._annotationValues.add(v);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String s = AnnotationParser.normalize(desc);
            ListValue v = new ListValue(s);
            this._annotationValues.add(v);
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(s, v.getList());
            return visitor;
        }

        public AnnotationVisitor visitArray(String name) {
            ListValue v = new ListValue(name);
            this._annotationValues.add(v);
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(null, v.getList());
            return visitor;
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public void visitEnd() {
        }
    }

    public static interface FieldHandler {
        public void handle(String var1, String var2, int var3, String var4, String var5, Object var6);
    }

    public static interface MethodHandler {
        public void handle(String var1, String var2, int var3, String var4, String var5, String[] var6);
    }

    public static interface ClassHandler {
        public void handle(String var1, int var2, int var3, String var4, String var5, String[] var6);
    }

    public static interface DiscoverableAnnotationHandler {
        public void handleClass(String var1, int var2, int var3, String var4, String var5, String[] var6, String var7, List<Value> var8);

        public void handleMethod(String var1, String var2, int var3, String var4, String var5, String[] var6, String var7, List<Value> var8);

        public void handleField(String var1, String var2, int var3, String var4, String var5, Object var6, String var7, List<Value> var8);
    }

    public class ListValue
    extends Value {
        List<Value> _val;

        public ListValue(String name) {
            super(name);
            this._val = new ArrayList<Value>();
        }

        @Override
        public Object getValue() {
            return this._val;
        }

        public List<Value> getList() {
            return this._val;
        }

        public void addValue(Value v) {
            this._val.add(v);
        }

        public int size() {
            return this._val.size();
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("(");
            buff.append(this.getName());
            buff.append(":");
            for (Value n : this._val) {
                buff.append(" " + n.toString());
            }
            buff.append(")");
            return buff.toString();
        }
    }

    public class SimpleValue
    extends Value {
        Object _val;

        public SimpleValue(String name) {
            super(name);
        }

        public void setValue(Object val) {
            this._val = val;
        }

        @Override
        public Object getValue() {
            return this._val;
        }

        public String toString() {
            return "(" + this.getName() + ":" + this._val + ")";
        }
    }

    public abstract class Value {
        String _name;

        public Value(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public abstract Object getValue();
    }
}

