/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EJBs;
import javax.ejb.EntityBean;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.jws.WebService;
import javax.persistence.PersistenceContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.Proxy;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.Strings;
import org.apache.xbean.finder.ClassFinder;

public class CheckClasses
extends ValidationBase {
    private static final List<Class<? extends Annotation>> beanOnlyAnnotations = new ArrayList<Class<? extends Annotation>>();

    @Override
    public void validate(EjbModule ejbModule) {
        for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            try {
                Class<?> beanClass = this.check_hasEjbClass(enterpriseBean);
                if (beanClass == null || !(enterpriseBean instanceof RemoteBean)) continue;
                RemoteBean b = (RemoteBean)enterpriseBean;
                this.check_isEjbClass(b);
                this.check_hasDependentClasses(b, b.getEjbClass(), "ejb-class");
                this.check_hasInterface(b);
                if (b.getRemote() != null) {
                    this.checkInterface(b, beanClass, "remote", b.getRemote());
                }
                if (b.getHome() != null) {
                    this.checkInterface(b, beanClass, "home", b.getHome());
                }
                if (b.getLocal() != null) {
                    this.checkInterface(b, beanClass, "local", b.getLocal());
                }
                if (b.getLocalHome() != null) {
                    this.checkInterface(b, beanClass, "local-home", b.getLocalHome());
                }
                if (!(b instanceof SessionBean)) continue;
                SessionBean sessionBean = (SessionBean)b;
                for (String interfce : sessionBean.getBusinessLocal()) {
                    this.checkInterface(b, beanClass, "business-local", interfce);
                }
                for (String interfce : sessionBean.getBusinessRemote()) {
                    this.checkInterface(b, beanClass, "business-remote", interfce);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(enterpriseBean.getEjbName(), e);
            }
        }
        for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getInterceptors()) {
            this.check_hasInterceptorClass((Interceptor)enterpriseBean);
        }
    }

    private void checkInterface(RemoteBean b, Class<?> beanClass, String tag, String className) {
        Class<?> interfce = this.lookForClass(className, tag, b.getEjbName());
        if (interfce == null) {
            return;
        }
        this.check_hasDependentClasses(b, className, tag);
        tag = Strings.lcfirst(Strings.camelCase(tag));
        if (this.isValidInterface(b, interfce, beanClass, tag)) {
            // empty if block
        }
        ClassFinder finder = new ClassFinder(new Class[]{interfce});
        for (Class<? extends Annotation> annotation : beanOnlyAnnotations) {
            if (interfce.isAnnotationPresent(annotation)) {
                this.warn((EnterpriseBean)b, "interface.beanOnlyAnnotation", annotation.getSimpleName(), interfce.getName(), b.getEjbClass());
            }
            for (Method method : finder.findAnnotatedMethods(annotation)) {
                this.warn((EnterpriseBean)b, "interfaceMethod.beanOnlyAnnotation", annotation.getSimpleName(), interfce.getName(), method.getName(), b.getEjbClass());
            }
        }
    }

    private void check_hasInterface(RemoteBean b) {
        if (b.getRemote() != null) {
            return;
        }
        if (b.getLocal() != null) {
            return;
        }
        Class<?> beanClass = null;
        try {
            beanClass = this.loadClass(b.getEjbClass());
        }
        catch (OpenEJBException openEJBException) {
            // empty catch block
        }
        if (b instanceof org.apache.openejb.jee.EntityBean) {
            this.fail((EnterpriseBean)b, "noInterfaceDeclared.entity", beanClass.getSimpleName());
            return;
        }
        if (b.getBusinessLocal().size() > 0) {
            return;
        }
        if (b.getBusinessRemote().size() > 0) {
            return;
        }
        if (((SessionBean)b).getServiceEndpoint() != null) {
            return;
        }
        if (beanClass.isAnnotationPresent(WebService.class)) {
            return;
        }
    }

    private void check_hasDependentClasses(RemoteBean b, String className, String type) {
        try {
            ClassLoader cl = this.module.getClassLoader();
            Class<?> clazz = cl.loadClass(className);
            for (Field field : clazz.getFields()) {
                ((Object)field).toString();
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                accessibleObject.toString();
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                accessibleObject.toString();
            }
            for (Annotation annotation : clazz.getAnnotations()) {
                ((Object)annotation).toString();
            }
            for (Class<?> clazz2 : clazz.getClasses()) {
                if (!clazz2.isEnum()) continue;
                clazz2.toString();
            }
        }
        catch (ClassNotFoundException e) {
            String missingClass = e.getMessage();
            this.fail((EnterpriseBean)b, "missing.dependent.class", className, missingClass, type, b.getEjbName());
        }
        catch (NoClassDefFoundError e) {
            String missingClass = e.getMessage();
            this.fail((EnterpriseBean)b, "missing.dependent.class", className, missingClass, type, b.getEjbName());
        }
    }

    public Class<?> check_hasEjbClass(EnterpriseBean b) {
        boolean isDynamicProxyImpl;
        String ejbName = b.getEjbName();
        Class<?> beanClass = this.lookForClass(b.getEjbClass(), "ejb-class", ejbName);
        boolean bl = isDynamicProxyImpl = beanClass.getAnnotation(PersistenceContext.class) != null || beanClass.getAnnotation(Proxy.class) != null;
        if (beanClass == null) {
            return null;
        }
        if (beanClass.isInterface() && !isDynamicProxyImpl) {
            this.fail(ejbName, "interfaceDeclaredAsBean", beanClass.getName());
        }
        if (this.isCmp(b)) {
            return beanClass;
        }
        if (Modifier.isAbstract(beanClass.getModifiers()) && !isDynamicProxyImpl) {
            this.fail(ejbName, "abstractDeclaredAsBean", beanClass.getName());
        }
        return beanClass;
    }

    private void check_hasInterceptorClass(Interceptor i) {
        this.lookForClass(i.getInterceptorClass(), "interceptor-class", "Interceptor");
    }

    private void check_isEjbClass(RemoteBean b) {
        if (!(b instanceof SessionBean) && b instanceof org.apache.openejb.jee.EntityBean) {
            this.compareTypes(b, b.getEjbClass(), EntityBean.class);
        }
    }

    private Class<?> lookForClass(String clazz, String type, String ejbName) {
        try {
            return this.loadClass(clazz);
        }
        catch (OpenEJBException e) {
            this.fail(ejbName, "missing.class", clazz, type, ejbName);
        }
        catch (NoClassDefFoundError e) {
            this.fail(ejbName, "misslocated.class", clazz, type, ejbName, e.getMessage());
            throw e;
        }
        return null;
    }

    private boolean isValidInterface(RemoteBean b, Class clazz, Class beanClass, String tag) {
        if (clazz.equals(beanClass)) {
            this.fail((EnterpriseBean)b, "xml." + tag + ".beanClass", clazz.getName());
        } else if (!clazz.isInterface()) {
            this.fail((EnterpriseBean)b, "xml." + tag + ".notInterface", clazz.getName());
        } else if (EJBHome.class.isAssignableFrom(clazz)) {
            if (tag.equals("home")) {
                return true;
            }
            this.fail((EnterpriseBean)b, "xml." + tag + ".ejbHome", clazz.getName());
        } else if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            if (tag.equals("localHome")) {
                return true;
            }
            this.fail((EnterpriseBean)b, "xml." + tag + ".ejbLocalHome", clazz.getName());
        } else if (EJBObject.class.isAssignableFrom(clazz)) {
            if (tag.equals("remote")) {
                return true;
            }
            this.fail((EnterpriseBean)b, "xml." + tag + ".ejbObject", clazz.getName());
        } else if (EJBLocalObject.class.isAssignableFrom(clazz)) {
            if (tag.equals("local")) {
                return true;
            }
            this.fail((EnterpriseBean)b, "xml." + tag + ".ejbLocalObject", clazz.getName());
        } else {
            if (tag.equals("businessLocal") || tag.equals("businessRemote")) {
                return true;
            }
            if (clazz.isAnnotationPresent(Local.class)) {
                this.fail((EnterpriseBean)b, "xml." + tag + ".businessLocal", clazz.getName());
            } else if (clazz.isAnnotationPresent(Remote.class)) {
                this.fail((EnterpriseBean)b, "xml." + tag + ".businessRemote", clazz.getName());
            } else {
                this.fail((EnterpriseBean)b, "xml." + tag + ".unknown", clazz.getName());
            }
        }
        return false;
    }

    private void compareTypes(RemoteBean b, String clazz1, Class<?> class2) {
        Class<?> class1 = null;
        try {
            class1 = this.loadClass(clazz1);
        }
        catch (OpenEJBException e) {
            return;
        }
        if (class1 != null && !class2.isAssignableFrom(class1)) {
            this.fail((EnterpriseBean)b, "wrong.class.type", clazz1, class2.getName());
        }
    }

    @Override
    protected Class<?> loadClass(String clazz) throws OpenEJBException {
        ClassLoader cl = this.module.getClassLoader();
        try {
            return Class.forName(clazz, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new OpenEJBException(SafeToolkit.messages.format("cl0007", clazz, this.module.getJarLocation()), cnfe);
        }
    }

    static {
        beanOnlyAnnotations.add(PostConstruct.class);
        beanOnlyAnnotations.add(PreDestroy.class);
        beanOnlyAnnotations.add(Resource.class);
        beanOnlyAnnotations.add(Resources.class);
        beanOnlyAnnotations.add(DeclareRoles.class);
        beanOnlyAnnotations.add(DenyAll.class);
        beanOnlyAnnotations.add(PermitAll.class);
        beanOnlyAnnotations.add(RolesAllowed.class);
        beanOnlyAnnotations.add(RunAs.class);
        beanOnlyAnnotations.add(EJB.class);
        beanOnlyAnnotations.add(EJBs.class);
        beanOnlyAnnotations.add(Init.class);
        beanOnlyAnnotations.add(PostActivate.class);
        beanOnlyAnnotations.add(PrePassivate.class);
        beanOnlyAnnotations.add(Remove.class);
        beanOnlyAnnotations.add(Timeout.class);
        beanOnlyAnnotations.add(TransactionAttribute.class);
        beanOnlyAnnotations.add(TransactionManagement.class);
    }
}

