/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.scoping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.ImportedBundle;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scoper {
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME = "bundle-symbolic-name";
    public static final String SCOPE_SEPARATOR = "-";
    private static final int BUNDLE_MANIFEST_VERSION_FOR_OSGI_R4 = 2;
    private static final String SCOPING_ATTRIBUTE_NAME = "module_scope";
    private final Logger logger;
    private final List<BundleManifest> bundleManifests;
    private final String scopeName;
    private final String scopePrefix;
    private final Map<String, Version> exportedPackages;
    private final Map<String, Version> bundles;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public Scoper(List<BundleManifest> bundleManifests, String scopeName) {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.exportedPackages = new HashMap<String, Version>();
            this.bundles = new HashMap<String, Version>();
            this.bundleManifests = bundleManifests;
            this.scopeName = scopeName;
            this.scopePrefix = String.valueOf(scopeName) + SCOPE_SEPARATOR;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void scope() throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                this.scopeReferents();
                this.scopeReferences();
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeReferents() throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                for (BundleManifest bundleManifest : this.bundleManifests) {
                    this.scopeBundleReferents(bundleManifest, true);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeBundleReferents(BundleManifest bundleManifest, boolean allowDuplicates) throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                this.logger.debug("Bundle manifest before scoping:\n{}", (Object)bundleManifest);
                if (bundleManifest.getBundleManifestVersion() < 2) {
                    throw new UnsupportedBundleManifestVersionException();
                }
                for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
                    this.scopeExportedPackage(exportedPackage, allowDuplicates);
                }
                this.setModuleScope(bundleManifest);
                String symbolicName = bundleManifest.getBundleSymbolicName().getSymbolicName();
                if (symbolicName.startsWith(this.scopeName)) {
                    symbolicName = symbolicName.substring(this.scopeName.length() + 1);
                }
                this.bundles.put(symbolicName, bundleManifest.getBundleVersion());
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void setModuleScope(BundleManifest bundleManifest) {
        try {
            bundleManifest.setModuleScope(this.scopeName);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeExportedPackage(ExportedPackage exportedPackage, boolean allowDuplicates) throws DuplicateExportException, UnsupportedBundleManifestVersionException {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                exportedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
                exportedPackage.getMandatory().add(SCOPING_ATTRIBUTE_NAME);
                Version packageVersion = exportedPackage.getVersion();
                if (this.exportedPackages.containsKey(exportedPackage.getPackageName())) {
                    if (!allowDuplicates) {
                        this.diagnoseDuplicateExport(exportedPackage.getPackageName());
                    }
                } else {
                    this.exportedPackages.put(exportedPackage.getPackageName(), packageVersion);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void diagnoseDuplicateExport(String packageName) throws DuplicateExportException, UnsupportedBundleManifestVersionException {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                StringBuffer exporters = new StringBuffer();
                boolean first = true;
                Iterator<BundleManifest> iterator = this.bundleManifests.iterator();
                block4: while (true) {
                    if (!iterator.hasNext()) {
                        throw new DuplicateExportException(packageName, exporters.toString(), null);
                    }
                    BundleManifest bundleManifest = iterator.next();
                    if (bundleManifest.getBundleManifestVersion() < 2) {
                        throw new UnsupportedBundleManifestVersionException();
                    }
                    Iterator iterator2 = bundleManifest.getExportPackage().getExportedPackages().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block4;
                        ExportedPackage exportedPackage = (ExportedPackage)iterator2.next();
                        if (!packageName.equals(exportedPackage.getPackageName())) continue;
                        if (!first) {
                            exporters.append(", ");
                        }
                        first = false;
                        exporters.append(Scoper.getUnscopedSymbolicName(bundleManifest));
                        exporters.append(" ");
                        exporters.append(bundleManifest.getBundleVersion());
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static String getUnscopedSymbolicName(BundleManifest bundleManifest) {
        try {
            String symbolicName = null;
            BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
            if (bundleSymbolicName != null) {
                String scopeName;
                symbolicName = bundleSymbolicName.getSymbolicName();
                String moduleScope = bundleManifest.getModuleScope();
                if (moduleScope != null && symbolicName.startsWith(scopeName = String.valueOf(moduleScope) + SCOPE_SEPARATOR)) {
                    symbolicName = symbolicName.substring(scopeName.length());
                }
            }
            return symbolicName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String getUnscopedSymbolicName(String bundleSymbolicName) {
        try {
            String symbolicName = null;
            if (bundleSymbolicName != null && (symbolicName = bundleSymbolicName).startsWith(this.scopePrefix)) {
                symbolicName = symbolicName.substring(this.scopePrefix.length());
            }
            return symbolicName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String getScopedSymbolicName(String bundleSymbolicName) {
        try {
            String symbolicName = this.getUnscopedSymbolicName(bundleSymbolicName);
            if (this.bundles.containsKey(symbolicName)) {
                return String.valueOf(this.scopePrefix) + symbolicName;
            }
            return bundleSymbolicName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeReferences() {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                for (BundleManifest bundleManifest : this.bundleManifests) {
                    this.scopeBundleReferences(bundleManifest);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeBundleReferences(BundleManifest bundleManifest) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                for (ImportedPackage importedPackage : bundleManifest.getImportPackage().getImportedPackages()) {
                    this.scopeImportedPackage(importedPackage);
                }
                this.scopeDynamicImports(bundleManifest);
                this.scopeImportBundle(bundleManifest);
                this.scopeRequireBundle(bundleManifest);
                this.scopeFragmentHost(bundleManifest);
                this.logger.debug("Bundle manifest after scoping:\n{}", (Object)bundleManifest);
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeDynamicImports(BundleManifest bundleManifest) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                DynamicImportPackage unscopedList = BundleManifestFactory.createBundleManifest().getDynamicImportPackage();
                List dynamicallyImportedPackages = bundleManifest.getDynamicImportPackage().getDynamicallyImportedPackages();
                for (DynamicallyImportedPackage dynamicallyImportedPackage : dynamicallyImportedPackages) {
                    this.scopeDynamicallyImportedPackage(dynamicallyImportedPackage);
                    this.addUnscopedDynamicallyImportedPackage(unscopedList, dynamicallyImportedPackage);
                }
                dynamicallyImportedPackages.addAll(unscopedList.getDynamicallyImportedPackages());
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addUnscopedDynamicallyImportedPackage(DynamicImportPackage unscopedList, DynamicallyImportedPackage dynamicallyImportedPackage) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                unscopedList.addDynamicallyImportedPackage(dynamicallyImportedPackage.getPackageName());
                List unscopedDynamicallyImportedPackages = unscopedList.getDynamicallyImportedPackages();
                DynamicallyImportedPackage unscopedDIP = (DynamicallyImportedPackage)unscopedDynamicallyImportedPackages.get(unscopedDynamicallyImportedPackages.size() - 1);
                Map attributes = unscopedDIP.getAttributes();
                attributes.putAll(dynamicallyImportedPackage.getAttributes());
                attributes.remove(SCOPING_ATTRIBUTE_NAME);
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeImportedPackage(ImportedPackage importedPackage) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                Version exportedVersion = this.exportedPackages.get(importedPackage.getPackageName());
                if (exportedVersion != null) {
                    VersionRange importVersionRange = importedPackage.getVersion();
                    if (importVersionRange.includes(exportedVersion)) {
                        String symbolicName;
                        importedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
                        if (importedPackage.getAttributes().containsKey(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME) && this.bundles.containsKey(symbolicName = (String)importedPackage.getAttributes().get(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME))) {
                            importedPackage.getAttributes().put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME, String.valueOf(this.scopePrefix) + symbolicName);
                        }
                    } else {
                        this.logger.warn("Import of package '{}' was not scoped to scope '{}' as its version range did not include the version of the scoped export of the package", (Object)importedPackage.getPackageName(), (Object)this.scopeName);
                    }
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeDynamicallyImportedPackage(DynamicallyImportedPackage dynamicallyImportedPackage) {
        try {
            try {
                String symbolicName;
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
                dynamicallyImportedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
                if (dynamicallyImportedPackage.getAttributes().containsKey(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME) && this.bundles.containsKey(symbolicName = (String)dynamicallyImportedPackage.getAttributes().get(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME))) {
                    dynamicallyImportedPackage.getAttributes().put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME, String.valueOf(this.scopePrefix) + symbolicName);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeRequireBundle(BundleManifest bundleManifest) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
                List requiredBundles = bundleManifest.getRequireBundle().getRequiredBundles();
                for (RequiredBundle requiredBundle : requiredBundles) {
                    String requiredBundleSymbolicName = requiredBundle.getBundleSymbolicName();
                    if (!this.bundles.containsKey(requiredBundleSymbolicName)) continue;
                    Version version = this.bundles.get(requiredBundleSymbolicName);
                    VersionRange requiredVersionRange = requiredBundle.getBundleVersion();
                    if (!requiredVersionRange.includes(version)) continue;
                    requiredBundle.setBundleSymbolicName(String.valueOf(this.scopePrefix) + requiredBundleSymbolicName);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeImportBundle(BundleManifest bundleManifest) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
                List importedBundles = bundleManifest.getImportBundle().getImportedBundles();
                for (ImportedBundle importedBundle : importedBundles) {
                    String importedBundleSymbolicName = importedBundle.getBundleSymbolicName();
                    if (!this.bundles.containsKey(importedBundleSymbolicName)) continue;
                    Version version = this.bundles.get(importedBundleSymbolicName);
                    VersionRange versionRange = importedBundle.getVersion();
                    if (!versionRange.includes(version)) continue;
                    importedBundle.setBundleSymbolicName(String.valueOf(this.scopePrefix) + importedBundleSymbolicName);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void scopeFragmentHost(BundleManifest bundleManifest) {
        try {
            try {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
                FragmentHost fragmentHost = bundleManifest.getFragmentHost();
                String bundleSymbolicName = fragmentHost.getBundleSymbolicName();
                if (bundleSymbolicName != null && this.bundles.containsKey(bundleSymbolicName)) {
                    fragmentHost.setBundleSymbolicName(String.valueOf(this.scopePrefix) + bundleSymbolicName);
                }
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
                return;
            }
            catch (Throwable throwable) {
                Scoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("Scoper.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scope", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "", "", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateBundleSymbolicNameException:", "void"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeReferents", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "", "", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateBundleSymbolicNameException:", "void"), 100);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeDynamicallyImportedPackage", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage:", "dynamicallyImportedPackage:", "", "void"), 305);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeRequireBundle", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "bundleManifest:", "", "void"), 320);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeImportBundle", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "bundleManifest:", "", "void"), 339);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeFragmentHost", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "bundleManifest:", "", "void"), 358);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeBundleReferents", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:boolean:", "bundleManifest:allowDuplicates:", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateBundleSymbolicNameException:", "void"), 115);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeExportedPackage", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.ExportedPackage:boolean:", "exportedPackage:allowDuplicates:", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException:", "void"), 151);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "diagnoseDuplicateExport", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "java.lang.String:", "packageName:", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException:org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException:", "void"), 169);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeReferences", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "", "", "", "void"), 238);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeBundleReferences", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "bundleManifest:", "", "void"), 249);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeDynamicImports", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "bundleManifest:", "", "void"), 261);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addUnscopedDynamicallyImportedPackage", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage:org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage:", "unscopedList:dynamicallyImportedPackage:", "", "void"), 271);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scopeImportedPackage", "org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper", "org.eclipse.virgo.util.osgi.manifest.ImportedPackage:", "importedPackage:", "", "void"), 285);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper");
    }

    public static class DuplicateBundleSymbolicNameException
    extends Exception {
        private static final long serialVersionUID = -4228236795055040322L;
        private final String bundleSymbolicName;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public DuplicateBundleSymbolicNameException(String bundleSymbolicName) {
            try {
                this.bundleSymbolicName = bundleSymbolicName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getBundleSymbolicName() {
            try {
                return this.bundleSymbolicName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateBundleSymbolicNameException");
        }
    }

    public static class DuplicateExportException
    extends Exception {
        private static final long serialVersionUID = -6672058951941449763L;
        private final String packageName;
        private final String exporters;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private DuplicateExportException(String packageName, String exporters) {
            try {
                this.packageName = packageName;
                this.exporters = exporters;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getPackageName() {
            try {
                return this.packageName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getExporters() {
            try {
                return this.exporters;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DuplicateExportException(String string, String string2, DuplicateExportException duplicateExportException) {
            String string3 = string2;
            String string4 = string;
            DuplicateExportException ajc$aspectInstance = this;
            try {
                void exporters;
                void packageName;
                ajc$aspectInstance.packageName = packageName;
                ajc$aspectInstance.exporters = exporters;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$DuplicateExportException");
        }
    }

    public static class UnsupportedBundleManifestVersionException
    extends Exception {
        private static final long serialVersionUID = -282020071571817876L;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        UnsupportedBundleManifestVersionException() {
            super("Cannot scope a bundle which does not specify a bundle manifest version of at least 2");
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public int getLowestSupportedVersion() {
            try {
                return 2;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper$UnsupportedBundleManifestVersionException");
        }
    }
}

