/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jolokia.http.AgentServlet;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.LogHandler;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class JolokiaServlet
extends AgentServlet {
    private static final long serialVersionUID = 23L;
    private BundleContext bundleContextGiven;
    private ServiceTracker logTracker;
    private static final ThreadLocal<BundleContext> BUNDLE_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    public JolokiaServlet() {
        this((BundleContext)null);
    }

    public JolokiaServlet(BundleContext pContext) {
        this(pContext, null);
    }

    public JolokiaServlet(BundleContext pContext, Restrictor pRestrictor) {
        super(pRestrictor);
        this.bundleContextGiven = pContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig pServletConfig) throws ServletException {
        BUNDLE_CONTEXT_THREAD_LOCAL.set(this.getBundleContext(pServletConfig));
        try {
            super.init(pServletConfig);
        }
        finally {
            BUNDLE_CONTEXT_THREAD_LOCAL.remove();
        }
    }

    protected LogHandler createLogHandler(ServletConfig pServletConfig) {
        BundleContext ctx = this.getBundleContext(pServletConfig);
        if (ctx != null) {
            this.logTracker = new ServiceTracker(ctx, LogService.class.getName(), null);
            this.logTracker.open();
            return new ActivatorLogHandler(this.logTracker);
        }
        return super.createLogHandler(pServletConfig);
    }

    public void destroy() {
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.bundleContextGiven = null;
        super.destroy();
    }

    public static BundleContext getCurrentBundleContext() {
        return BUNDLE_CONTEXT_THREAD_LOCAL.get();
    }

    private BundleContext getBundleContext(ServletConfig pServletConfig) {
        if (this.bundleContextGiven == null) {
            ServletContext servletContext = pServletConfig.getServletContext();
            return (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        }
        return this.bundleContextGiven;
    }

    private final class ActivatorLogHandler
    implements LogHandler {
        private ServiceTracker logTracker;

        private ActivatorLogHandler(ServiceTracker pLogTracker) {
            this.logTracker = pLogTracker;
        }

        public void debug(String message) {
            this.doLog(4, message);
        }

        public void info(String message) {
            this.doLog(3, message);
        }

        private void doLog(int level, String message) {
            LogService logService = (LogService)this.logTracker.getService();
            if (logService != null) {
                logService.log(level, message);
            } else {
                JolokiaServlet.this.log(message);
            }
        }

        public void error(String message, Throwable t) {
            LogService logService = (LogService)this.logTracker.getService();
            if (logService != null) {
                logService.log(1, message, t);
            } else {
                JolokiaServlet.this.log(message, t);
            }
        }
    }
}

