/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.virgo.util.common.Assert;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File in, File out) throws IOException {
        Assert.notNull((Object)in, (String)"No input File specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No output File specified", (Object[])new Object[0]);
        return FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Assert.notNull((Object)in, (String)"No input byte array specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No output File specified", (Object[])new Object[0]);
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        FileCopyUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        Assert.notNull((Object)in, (String)"No input File specified", (Object[])new Object[0]);
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        Assert.notNull((Object)in, (String)"No InputStream specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No OutputStream specified", (Object[])new Object[0]);
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull((Object)in, (String)"No input byte array specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No OutputStream specified", (Object[])new Object[0]);
        try {
            out.write(in);
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        Assert.notNull((Object)in, (String)"No Reader specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No Writer specified", (Object[])new Object[0]);
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public static void copy(String in, Writer out) throws IOException {
        Assert.notNull((Object)in, (String)"No input String specified", (Object[])new Object[0]);
        Assert.notNull((Object)out, (String)"No Writer specified", (Object[])new Object[0]);
        try {
            out.write(in);
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileCopyUtils.copy(in, (Writer)out);
        return out.toString();
    }
}

