/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.SessionAttributesHandler;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class ModelFactory {
    private static final Log logger = LogFactory.getLog(ModelFactory.class);
    private final List<ModelMethod> modelMethods = new ArrayList<ModelMethod>();
    private final WebDataBinderFactory dataBinderFactory;
    private final SessionAttributesHandler sessionAttributesHandler;

    public ModelFactory(List<InvocableHandlerMethod> handlerMethods, WebDataBinderFactory binderFactory, SessionAttributesHandler attributeHandler) {
        if (handlerMethods != null) {
            for (InvocableHandlerMethod handlerMethod : handlerMethods) {
                this.modelMethods.add(new ModelMethod(handlerMethod));
            }
        }
        this.dataBinderFactory = binderFactory;
        this.sessionAttributesHandler = attributeHandler;
    }

    public void initModel(NativeWebRequest request, ModelAndViewContainer container, HandlerMethod handlerMethod) throws Exception {
        Map<String, Object> sessionAttributes = this.sessionAttributesHandler.retrieveAttributes(request);
        container.mergeAttributes(sessionAttributes);
        this.invokeModelAttributeMethods(request, container);
        for (String name : this.findSessionAttributeArguments(handlerMethod)) {
            if (container.containsAttribute(name)) continue;
            Object value = this.sessionAttributesHandler.retrieveAttribute(request, name);
            if (value == null) {
                throw new HttpSessionRequiredException("Expected session attribute '" + name + "'");
            }
            container.addAttribute(name, value);
        }
    }

    private void invokeModelAttributeMethods(NativeWebRequest request, ModelAndViewContainer container) throws Exception {
        while (!this.modelMethods.isEmpty()) {
            String returnValueName;
            InvocableHandlerMethod modelMethod = this.getNextModelMethod(container).getHandlerMethod();
            String modelName = modelMethod.getMethodAnnotation(ModelAttribute.class).value();
            if (container.containsAttribute(modelName)) continue;
            Object returnValue = modelMethod.invokeForRequest(request, container, new Object[0]);
            if (modelMethod.isVoid() || container.containsAttribute(returnValueName = ModelFactory.getNameForReturnValue(returnValue, modelMethod.getReturnType()))) continue;
            container.addAttribute(returnValueName, returnValue);
        }
    }

    private ModelMethod getNextModelMethod(ModelAndViewContainer container) {
        for (ModelMethod modelMethod : this.modelMethods) {
            if (!modelMethod.checkDependencies(container)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Selected @ModelAttribute method " + modelMethod));
            }
            this.modelMethods.remove(modelMethod);
            return modelMethod;
        }
        ModelMethod modelMethod = this.modelMethods.get(0);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Selected @ModelAttribute method (not present: " + modelMethod.getUnresolvedDependencies(container) + ") " + modelMethod));
        }
        this.modelMethods.remove(modelMethod);
        return modelMethod;
    }

    private List<String> findSessionAttributeArguments(HandlerMethod handlerMethod) {
        ArrayList<String> result = new ArrayList<String>();
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            Class paramType;
            String name;
            if (!parameter.hasParameterAnnotation(ModelAttribute.class) || !this.sessionAttributesHandler.isHandlerSessionAttribute(name = ModelFactory.getNameForParameter(parameter), paramType = parameter.getParameterType())) continue;
            result.add(name);
        }
        return result;
    }

    public void updateModel(NativeWebRequest request, ModelAndViewContainer container) throws Exception {
        ModelMap defaultModel = container.getDefaultModel();
        if (container.getSessionStatus().isComplete()) {
            this.sessionAttributesHandler.cleanupAttributes(request);
        } else {
            this.sessionAttributesHandler.storeAttributes(request, (Map<String, ?>)defaultModel);
        }
        if (!container.isRequestHandled() && container.getModel() == defaultModel) {
            this.updateBindingResult(request, defaultModel);
        }
    }

    private void updateBindingResult(NativeWebRequest request, ModelMap model) throws Exception {
        ArrayList keyNames = new ArrayList(model.keySet());
        for (String name : keyNames) {
            String bindingResultKey;
            Object value;
            if (!this.isBindingCandidate(name, value = model.get((Object)name)) || model.containsAttribute(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + name)) continue;
            WebDataBinder dataBinder = this.dataBinderFactory.createBinder(request, value, name);
            model.put((Object)bindingResultKey, (Object)dataBinder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String attributeName, Object value) {
        Class<?> attrType;
        if (attributeName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        Class<?> clazz = attrType = value != null ? value.getClass() : null;
        if (this.sessionAttributesHandler.isHandlerSessionAttribute(attributeName, attrType)) {
            return true;
        }
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute ann = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        String name = ann != null ? ann.value() : null;
        return StringUtils.hasText((String)name) ? name : Conventions.getVariableNameForParameter((MethodParameter)parameter);
    }

    public static String getNameForReturnValue(Object returnValue, MethodParameter returnType) {
        ModelAttribute ann = (ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class);
        if (ann != null && StringUtils.hasText((String)ann.value())) {
            return ann.value();
        }
        Method method = returnType.getMethod();
        Class containingClass = returnType.getContainingClass();
        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)containingClass);
        return Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)returnValue);
    }

    private static class ModelMethod {
        private final InvocableHandlerMethod handlerMethod;
        private final Set<String> dependencies = new HashSet<String>();

        public ModelMethod(InvocableHandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!parameter.hasParameterAnnotation(ModelAttribute.class)) continue;
                this.dependencies.add(ModelFactory.getNameForParameter(parameter));
            }
        }

        public InvocableHandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public boolean checkDependencies(ModelAndViewContainer mavContainer) {
            for (String name : this.dependencies) {
                if (mavContainer.containsAttribute(name)) continue;
                return false;
            }
            return true;
        }

        public List<String> getUnresolvedDependencies(ModelAndViewContainer mavContainer) {
            ArrayList<String> result = new ArrayList<String>(this.dependencies.size());
            for (String name : this.dependencies) {
                if (mavContainer.containsAttribute(name)) continue;
                result.add(name);
            }
            return result;
        }

        public String toString() {
            return this.handlerMethod.getMethod().toGenericString();
        }
    }
}

