/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json.simplifier;

import java.io.File;
import java.io.IOException;
import org.jolokia.converter.json.simplifier.SimplifierExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSimplifier
extends SimplifierExtractor<File> {
    public FileSimplifier() {
        super(File.class);
        Object[][] attrExtractors = new Object[][]{{"name", new NameAttributeExtractor()}, {"length", new LengthAttributeExtractor()}, {"directory", new IsDirectoryAttributeExtractor()}, {"canonicalPath", new PathAttributeExtractor()}, {"exists", new ExistsAttributeExtractor()}, {"lastModified", new LastModifiedAttributeExtractor()}};
        this.addExtractors(attrExtractors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LastModifiedAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private LastModifiedAttributeExtractor() {
        }

        @Override
        public Object extract(File value) {
            return value.lastModified();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExistsAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private ExistsAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.exists();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private PathAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsDirectoryAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private IsDirectoryAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.isDirectory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LengthAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private LengthAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<File> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.getName();
        }
    }
}

