/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ScopeNameFactory;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.BundleInstallArtifactGatheringGraphVisitor;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.ScopedPlanIdentifyingDirectedAcyclicGraphVisitor;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.ScopedPlanInstallArtifactProcessor;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ImportBundle;
import org.osgi.framework.Version;

final class SyntheticContextBundleCreatingTransformer
implements Transformer,
ScopedPlanInstallArtifactProcessor {
    private static final int SYNTHETIC_BUNDLE_MANIFEST_VERSION = 2;
    private static final String SYNTHETIC_CONTEXT_SUFFIX = "-synthetic.context";
    private final InstallArtifactGraphFactory installArtifactGraphFactory;
    private final ArtifactStorageFactory artifactStorageFactory;

    SyntheticContextBundleCreatingTransformer(InstallArtifactGraphFactory installArtifactGraphFactory, ArtifactStorageFactory artifactStorageFactory) {
        this.installArtifactGraphFactory = installArtifactGraphFactory;
        this.artifactStorageFactory = artifactStorageFactory;
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new ScopedPlanIdentifyingDirectedAcyclicGraphVisitor(this));
    }

    @Override
    public void processScopedPlanInstallArtifact(GraphNode<InstallArtifact> graph) throws DeploymentException {
        if (!this.syntheticContextExists(graph)) {
            Set<BundleInstallArtifact> childBundles = this.getBundlesInScope(graph);
            PlanInstallArtifact planArtifact = (PlanInstallArtifact)graph.getValue();
            String scopeName = this.determineSyntheticContextScopeName(planArtifact);
            String name = String.valueOf(scopeName) + SYNTHETIC_CONTEXT_SUFFIX;
            Version version = planArtifact.getVersion();
            ArtifactIdentity identity = new ArtifactIdentity("bundle", name, version, scopeName);
            BundleManifest syntheticContextBundleManifest = this.createSyntheticContextBundleManifest(identity, childBundles);
            ArtifactStorage artifactStorage = this.artifactStorageFactory.createDirectoryStorage(identity, String.valueOf(name) + ".jar");
            this.writeSyntheticContextBundle(syntheticContextBundleManifest, artifactStorage.getArtifactFS());
            GraphNode<InstallArtifact> syntheticContextBundle = this.installArtifactGraphFactory.constructInstallArtifactGraph(identity, artifactStorage, null, null);
            graph.addChild(syntheticContextBundle);
        }
    }

    private boolean syntheticContextExists(GraphNode<InstallArtifact> plan) {
        PlanInstallArtifact planInstallArtifact = (PlanInstallArtifact)plan.getValue();
        String syntheticContextBundleSymbolicName = String.valueOf(this.determineSyntheticContextScopeName(planInstallArtifact)) + SYNTHETIC_CONTEXT_SUFFIX;
        List children = plan.getChildren();
        for (GraphNode child : children) {
            if (!syntheticContextBundleSymbolicName.equals(((InstallArtifact)child.getValue()).getName())) continue;
            return true;
        }
        return false;
    }

    private Set<BundleInstallArtifact> getBundlesInScope(GraphNode<InstallArtifact> plan) {
        BundleInstallArtifactGatheringGraphVisitor visitor = new BundleInstallArtifactGatheringGraphVisitor();
        plan.visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        return visitor.getChildBundles();
    }

    private void writeSyntheticContextBundle(BundleManifest syntheticContextBundleManifest, ArtifactFS artifactFS) {
        ArtifactFSEntry entry = artifactFS.getEntry("META-INF/MANIFEST.MF");
        OutputStreamWriter manifestWriter = new OutputStreamWriter(entry.getOutputStream(), StandardCharsets.UTF_8);
        try {
            try {
                syntheticContextBundleManifest.write((Writer)manifestWriter);
            }
            catch (IOException ioe) {
                throw new FatalDeploymentException("Failed to write out synthetic context's manifest", (Throwable)ioe);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)manifestWriter);
        }
    }

    private BundleManifest createSyntheticContextBundleManifest(ArtifactIdentity identity, Set<BundleInstallArtifact> childBundles) {
        BundleManifest bundleManifest = BundleManifestFactory.createBundleManifest();
        bundleManifest.setBundleVersion(identity.getVersion());
        bundleManifest.setBundleManifestVersion(2);
        bundleManifest.getBundleSymbolicName().setSymbolicName(identity.getName());
        bundleManifest.setModuleScope(identity.getScopeName());
        this.addImportForEachChildBundle(bundleManifest, childBundles);
        return bundleManifest;
    }

    private String determineSyntheticContextScopeName(PlanInstallArtifact plan) {
        return ScopeNameFactory.createScopeName(plan.getName(), plan.getVersion());
    }

    private void addImportForEachChildBundle(BundleManifest bundleManifest, Set<BundleInstallArtifact> childBundles) {
        ImportBundle importBundle = bundleManifest.getImportBundle();
        for (BundleInstallArtifact bundle : childBundles) {
            String symbolicName = bundle.getName();
            importBundle.addImportedBundle(symbolicName);
        }
    }
}

