/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.virgo.nano.deployer.api.ArtifactIdentity;
import org.eclipse.virgo.nano.deployer.api.Deployer;
import org.eclipse.virgo.shell.Command;

@Command(value="install")
public final class InstallCommand {
    private static final String ARTIFACT_INSTALLATION_FAILED = "Artifact installation failed: %s";
    private static final String ARTIFACT_INSTALLED = "Artifact %s %s %s installed";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName deployerObjectName = new ObjectName("org.eclipse.virgo.kernel:category=Control,type=Deployer");

    @Command(value="")
    public List<String> install(String artifactLocation) {
        ArtifactIdentity artifactIdentity;
        try {
            artifactIdentity = this.getDeployer().install(artifactLocation);
        }
        catch (Exception e) {
            return Arrays.asList(String.format(ARTIFACT_INSTALLATION_FAILED, e.getMessage()));
        }
        return Arrays.asList(String.format(ARTIFACT_INSTALLED, artifactIdentity.getType(), artifactIdentity.getName(), artifactIdentity.getVersion()));
    }

    private Deployer getDeployer() {
        return JMX.newMXBeanProxy(this.server, this.deployerObjectName, Deployer.class);
    }
}

