/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.configurationadmin;

import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.configurationadmin.ConfigurationArtifact;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelConfigurationListener
implements ConfigurationListener {
    private final Logger logger;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final ConfigurationAdmin configurationAdmin;
    private final Region independentRegion;

    public ModelConfigurationListener(@NonNull RuntimeArtifactRepository artifactRepository, @NonNull BundleContext bundleContext, @NonNull ConfigurationAdmin configurationAdmin, @NonNull Region independentRegion) {
        Region region = independentRegion;
        ConfigurationAdmin configurationAdmin2 = configurationAdmin;
        BundleContext bundleContext2 = bundleContext;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)configurationAdmin2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.artifactRepository = artifactRepository;
            this.bundleContext = bundleContext;
            this.configurationAdmin = configurationAdmin;
            this.independentRegion = independentRegion;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        try {
            if (1 == event.getType()) {
                this.processUpdate(event);
            } else if (2 == event.getType()) {
                this.processDelete(event);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processUpdate(ConfigurationEvent event) {
        try {
            this.logger.info("Processing update event for '{}'", (Object)event.getPid());
            this.artifactRepository.add(this.createArtifact(event));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processDelete(ConfigurationEvent event) {
        try {
            this.logger.info("Processing delete event for '{}'", (Object)event.getPid());
            Artifact artifact = this.artifactRepository.getArtifact("configuration", event.getPid(), Version.emptyVersion, this.independentRegion);
            if (artifact instanceof ConfigurationArtifact) {
                this.artifactRepository.remove("configuration", event.getPid(), Version.emptyVersion, this.independentRegion);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ConfigurationArtifact createArtifact(ConfigurationEvent event) {
        try {
            return new ConfigurationArtifact(this.bundleContext, this.configurationAdmin, event.getPid(), this.independentRegion);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

