/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import org.jolokia.converter.Converters;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxWriteRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteHandler
extends JsonRequestHandler<JmxWriteRequest> {
    private Converters converters;

    public WriteHandler(Restrictor pRestrictor, Converters pConverters) {
        super(pRestrictor);
        this.converters = pConverters;
    }

    @Override
    public RequestType getType() {
        return RequestType.WRITE;
    }

    @Override
    protected void checkForRestriction(JmxWriteRequest pRequest) {
        if (!this.getRestrictor().isAttributeWriteAllowed(pRequest.getObjectName(), pRequest.getAttributeName())) {
            throw new SecurityException("Writing attribute " + pRequest.getAttributeName() + " forbidden for MBean " + pRequest.getObjectNameAsString());
        }
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection server, JmxWriteRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        try {
            return this.setAttribute(request, server);
        }
        catch (IntrospectionException exp) {
            throw new IllegalArgumentException("Cannot get info for MBean " + request.getObjectName() + ": " + exp, exp);
        }
        catch (InvalidAttributeValueException e) {
            throw new IllegalArgumentException("Invalid value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot set value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot set value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
    }

    private Object setAttribute(JmxWriteRequest request, MBeanServerConnection server) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException, InvalidAttributeValueException, IllegalAccessException, InvocationTargetException, IOException {
        Object oldValue = server.getAttribute(request.getObjectName(), request.getAttributeName());
        MBeanInfo mInfo = server.getMBeanInfo(request.getObjectName());
        MBeanAttributeInfo aInfo = null;
        for (MBeanAttributeInfo i : mInfo.getAttributes()) {
            if (!i.getName().equals(request.getAttributeName())) continue;
            aInfo = i;
            break;
        }
        Object[] values = aInfo instanceof OpenMBeanAttributeInfo ? this.getValues((OpenMBeanAttributeInfo)((Object)aInfo), oldValue, request) : this.getValues(aInfo.getType(), oldValue, request);
        Attribute attribute = new Attribute(request.getAttributeName(), values[0]);
        server.setAttribute(request.getObjectName(), attribute);
        return values[1];
    }

    @Override
    public boolean useReturnValueWithPath() {
        return false;
    }

    private Object[] getValues(String pType, Object pCurrentValue, JmxWriteRequest pRequest) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        List<String> pathParts = pRequest.getPathParts();
        Object newValue = pRequest.getValue();
        if (pathParts != null && pathParts.size() > 0) {
            if (pCurrentValue == null) {
                throw new IllegalArgumentException("Cannot set value with path when parent object is not set");
            }
            return new Object[]{pCurrentValue, this.converters.getToJsonConverter().setInnerValue(pCurrentValue, newValue, pathParts)};
        }
        return new Object[]{this.converters.getToObjectConverter().prepareValue(pType, newValue), pCurrentValue};
    }

    private Object[] getValues(OpenMBeanAttributeInfo pOpenTypeInfo, Object pCurrentValue, JmxWriteRequest pRequest) {
        List<String> pathParts = pRequest.getPathParts();
        if (pathParts != null && pathParts.size() > 0) {
            throw new IllegalArgumentException("Cannot set value for OpenType " + pOpenTypeInfo.getOpenType() + " with inner path " + pRequest.getPath() + " since OpenTypes are immutable");
        }
        return new Object[]{this.converters.getToOpenTypeConverter().convertToObject(pOpenTypeInfo.getOpenType(), pRequest.getValue()), pCurrentValue};
    }
}

