/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TomcatConfigLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatConfigLocator.class);
    static final String CONFIG_PATH_FRAMEWORK_PROPERTY = "org.eclipse.gemini.web.tomcat.config.path";
    private static final String DEFAULT_CONFIG_FILE_PATH = "config" + File.separator + "tomcat-server.xml";
    static final String CONFIG_PATH = "META-INF/tomcat";
    static final String DEFAULT_CONFIG_PATH = "META-INF/tomcat/default-server.xml";
    static final String USER_CONFIG_PATH = "server.xml";

    TomcatConfigLocator() {
    }

    static InputStream resolveConfigFile(BundleContext context) throws BundleException {
        Bundle bundle = context.getBundle();
        InputStream is = TomcatConfigLocator.lookupConfigInFileSystem(context);
        if (is == null) {
            is = TomcatConfigLocator.lookupConfigInBundle(bundle);
        }
        return is;
    }

    static Path resolveConfigDir(BundleContext context) {
        Path configFile = null;
        String path = context.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null && Files.exists(configFile = Paths.get(path, new String[0]), new LinkOption[0])) {
            return configFile.getParent();
        }
        path = System.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null && Files.exists(configFile = Paths.get(path, new String[0]), new LinkOption[0])) {
            return configFile.getParent();
        }
        configFile = Paths.get(DEFAULT_CONFIG_FILE_PATH, new String[0]);
        if (Files.exists(configFile, new LinkOption[0])) {
            return configFile.getParent();
        }
        return null;
    }

    static String resolveHostConfigDir(Path configDir, Host host) {
        StringBuilder xmlDir;
        if (configDir == null) {
            return null;
        }
        try {
            xmlDir = new StringBuilder(configDir.toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException iOException) {
            return null;
        }
        Container parent = host.getParent();
        if (parent instanceof Engine) {
            xmlDir.append('/');
            xmlDir.append(parent.getName());
        }
        xmlDir.append('/');
        xmlDir.append(host.getName());
        return xmlDir.toString();
    }

    private static InputStream lookupConfigInFileSystem(BundleContext context) {
        InputStream result = null;
        String path = context.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null) {
            result = TomcatConfigLocator.tryGetStreamForFilePath(path);
        }
        if (result == null) {
            result = TomcatConfigLocator.tryGetStreamForFilePath(DEFAULT_CONFIG_FILE_PATH);
        }
        return result;
    }

    private static InputStream tryGetStreamForFilePath(String filePath) {
        Path configFile = Paths.get(filePath, new String[0]);
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                InputStream fis = Files.newInputStream(configFile, new OpenOption[0]);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Configuring Tomcat from file [" + configFile + "].");
                }
                return fis;
            }
            catch (IOException e) {
                LOGGER.warn("Found config file on disk but then received IOException when trying to access.", (Throwable)e);
            }
        }
        return null;
    }

    private static InputStream lookupConfigInBundle(Bundle bundle) throws BundleException {
        URL entry = null;
        Enumeration entries = bundle.findEntries(CONFIG_PATH, USER_CONFIG_PATH, false);
        if (entries != null && entries.hasMoreElements()) {
            entry = (URL)entries.nextElement();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Configuring Tomcat from fragment entry [" + entry + "].");
            }
        } else {
            entry = bundle.getEntry(DEFAULT_CONFIG_PATH);
            if (entry == null) {
                throw new IllegalStateException("Unable to locate default Tomcat configuration. Is the [" + bundle + "] bundle corrupt?");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Configuring Tomcat from default config file.");
            }
        }
        try {
            return entry.openStream();
        }
        catch (IOException iOException) {
            throw new BundleException("Unable to open Tomcat configuration at [" + entry + "].");
        }
    }
}

