/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal.blueprint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.internal.blueprint.StandardTicker;
import org.eclipse.virgo.nano.core.internal.blueprint.Ticker;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContextDependencyMonitor
implements EventHandler {
    private static final String TOPIC_BLUEPRINT_EVENTS = "org/osgi/service/blueprint/container/";
    private static final String EVENT_WAITING = "org/osgi/service/blueprint/container/WAITING";
    private static final String EVENT_GRACE_PERIOD = "org/osgi/service/blueprint/container/GRACE_PERIOD";
    private static final String EVENT_FAILURE = "org/osgi/service/blueprint/container/FAILURE";
    private static final String EVENT_CREATED = "org/osgi/service/blueprint/container/CREATED";
    private static final int MAXIMUM_WARNING_INTERVAL = 60000;
    private static final int WARNING_INTERVAL_INCREASE_RATE_PERCENT = 200;
    private static final int INITIAL_WARNING_INTERVAL = 5000;
    private static final int SLOW_WARNING_INTERVAL = 300000;
    private final Logger logger;
    private final EventLogger eventLogger;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<Bundle, Map<ServiceDependency, Ticker>> tickers;
    private final Object monitor;

    public ApplicationContextDependencyMonitor(ScheduledExecutorService scheduledExecutorService, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.tickers = new HashMap<Bundle, Map<ServiceDependency, Ticker>>();
            this.monitor = new Object();
            this.scheduledExecutorService = scheduledExecutorService;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                Bundle bundle = (Bundle)event.getProperty("bundle");
                if (EVENT_WAITING.equals(event.getTopic())) {
                    List<ServiceDependency> serviceDependencies = this.createServiceDependencies(event);
                    if (serviceDependencies != null) {
                        for (ServiceDependency serviceDependency : serviceDependencies) {
                            this.addServiceDependencyTicker(serviceDependency, bundle);
                        }
                    }
                } else if (EVENT_GRACE_PERIOD.equals(event.getTopic())) {
                    List<ServiceDependency> remainingUnsatisfiedDependencies = this.createServiceDependencies(event);
                    if (remainingUnsatisfiedDependencies != null) {
                        this.changeInUnsatisfiedDependencies(remainingUnsatisfiedDependencies, bundle);
                    }
                } else if (EVENT_FAILURE.equals(event.getTopic())) {
                    String[] dependenciesArray = (String[])event.getProperty("dependencies");
                    if (dependenciesArray != null) {
                        List<ServiceDependency> serviceDependencies = this.createServiceDependencies(event);
                        if (serviceDependencies != null) {
                            this.serviceDependenciesTimedOut(serviceDependencies, bundle);
                        }
                    } else {
                        this.containerCreationFailed(bundle);
                    }
                } else if (EVENT_CREATED.equals(event.getTopic())) {
                    this.containerCreated(bundle);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void serviceDependenciesTimedOut(List<ServiceDependency> timedOutDependencies, Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> bundlesTickers = this.tickers.get(bundle);
            if (bundlesTickers != null) {
                for (ServiceDependency timedOutDependency : timedOutDependencies) {
                    Ticker ticker = bundlesTickers.remove(timedOutDependency);
                    if (ticker == null) continue;
                    this.dependencyTimedOut(timedOutDependency, ticker, bundle);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void containerCreationFailed(Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> tickers = this.tickers.remove(bundle);
            if (tickers != null) {
                for (Map.Entry<ServiceDependency, Ticker> ticker : tickers.entrySet()) {
                    ticker.getValue().cancel();
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void containerCreated(Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> bundlesTickers = this.tickers.remove(bundle);
            if (bundlesTickers != null) {
                for (Map.Entry<ServiceDependency, Ticker> entry : bundlesTickers.entrySet()) {
                    this.dependencySatisfied(entry.getKey(), entry.getValue(), bundle);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void changeInUnsatisfiedDependencies(List<ServiceDependency> remainingUnsatisfiedDependencies, Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> tickers = this.tickers.get(bundle);
            if (tickers != null) {
                Iterator<Map.Entry<ServiceDependency, Ticker>> entries = tickers.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<ServiceDependency, Ticker> entry = entries.next();
                    if (remainingUnsatisfiedDependencies.contains(entry.getKey())) continue;
                    this.dependencySatisfied(entry.getKey(), entry.getValue(), bundle);
                    entries.remove();
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void dependencySatisfied(ServiceDependency serviceDependency, Ticker ticker, Bundle bundle) {
        try {
            this.logger.info("Service dependency '{}' has been satisfied", (Object)serviceDependency);
            this.handleRemovedTicker(ticker, serviceDependency, bundle, true);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void dependencyTimedOut(ServiceDependency serviceDependency, Ticker ticker, Bundle bundle) {
        try {
            this.logger.info("Service dependency '{}' has timed out", (Object)serviceDependency);
            this.handleRemovedTicker(ticker, serviceDependency, bundle, false);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleRemovedTicker(Ticker ticker, ServiceDependency serviceDependency, Bundle bundle, boolean satisfied) {
        try {
            boolean hasTicked = ticker.cancel();
            if (hasTicked) {
                if (satisfied) {
                    this.eventLogger.log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_SATISFIED, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                } else {
                    this.eventLogger.log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_TIMED_OUT, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addServiceDependencyTicker(final ServiceDependency serviceDependency, final Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> serviceDependencyTickers = this.getServiceDependencyTickers(bundle);
            if (serviceDependencyTickers.containsKey(serviceDependency)) {
                this.logger.warn("Service dependency '{}' already being waited upon", (Object)serviceDependency);
            } else {
                boolean slowService = serviceDependency.getFilter().contains("(org.eclipse.virgo.server.slowservice=true)");
                serviceDependencyTickers.put(serviceDependency, StandardTicker.createExponentialTicker(slowService ? 300000 : 5000, 200L, slowService ? 300000 : 60000, new Callable<Void>(){
                    {
                        try {
                            try {
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try {
                            Object object = ApplicationContextDependencyMonitor.access$0(ApplicationContextDependencyMonitor.this);
                            synchronized (object) {
                                if (bundle.getState() == 1) {
                                    ApplicationContextDependencyMonitor.access$1(ApplicationContextDependencyMonitor.this, bundle);
                                } else {
                                    ApplicationContextDependencyMonitor.access$2(ApplicationContextDependencyMonitor.this).log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_DELAYED, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                                }
                                return null;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }
                }, this.scheduledExecutorService));
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Map<ServiceDependency, Ticker> getServiceDependencyTickers(Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> tickers = this.tickers.get(bundle);
            if (tickers == null) {
                tickers = new HashMap<ServiceDependency, Ticker>();
                this.tickers.put(bundle, tickers);
            }
            return tickers;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop() {
        try {
            this.scheduledExecutorService.shutdown();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private List<ServiceDependency> createServiceDependencies(Event event) {
        try {
            String[] filters = (String[])event.getProperty("dependencies");
            String[] beanNames = (String[])event.getProperty("bean.name");
            ArrayList<ServiceDependency> serviceDependencies = new ArrayList<ServiceDependency>();
            if (filters != null && beanNames != null) {
                int i = 0;
                while (i < filters.length) {
                    serviceDependencies.add(new ServiceDependency(filters[i], beanNames[i], null));
                    ++i;
                }
                return serviceDependencies;
            }
            return filters == null ? serviceDependencies : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Object access$0(ApplicationContextDependencyMonitor arg0) {
        try {
            return arg0.monitor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$1(ApplicationContextDependencyMonitor arg0, Bundle arg1) {
        try {
            arg0.containerCreationFailed(arg1);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ EventLogger access$2(ApplicationContextDependencyMonitor arg0) {
        try {
            return arg0.eventLogger;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final class ServiceDependency {
        private final String filter;
        private final String beanName;

        private ServiceDependency(String filter, String beanName) {
            try {
                this.filter = filter;
                this.beanName = beanName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getFilter() {
            try {
                return this.filter;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getBeanName() {
            try {
                return this.beanName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public int hashCode() {
            try {
                int result = 1;
                result = 31 * result + this.beanName.hashCode();
                result = 31 * result + this.filter.hashCode();
                return result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public boolean equals(Object obj) {
            try {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ServiceDependency other = (ServiceDependency)obj;
                if (!this.beanName.equals(other.beanName)) {
                    return false;
                }
                return this.filter.equals(other.filter);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String toString() {
            try {
                return String.valueOf(this.filter) + " " + this.beanName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ServiceDependency(String string, String string2, ServiceDependency serviceDependency) {
            String string3 = string2;
            String string4 = string;
            ServiceDependency ajc$aspectInstance = this;
            try {
                void beanName;
                void filter;
                ajc$aspectInstance.filter = filter;
                ajc$aspectInstance.beanName = beanName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

