/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.deployer.core.internal.ExistingNodeLocator;
import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

public class PlanResolver
implements Transformer {
    private static final String PROVISIONING_PROPERTY_NAME = "org.eclipse.virgo.kernel.provisioning";
    private static final String SCOPE_SEPARATOR = "-";
    private final InstallArtifactGraphInclosure installArtifactGraphInclosure;
    private final GCRoots gcRoots;
    private final Repository repository;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final EventLogger eventLogger;

    public PlanResolver(@NonNull InstallArtifactGraphInclosure installArtifactGraphInclosure, @NonNull GCRoots gcRoots, @NonNull Repository repository, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull EventLogger eventLogger) {
        this.installArtifactGraphInclosure = installArtifactGraphInclosure;
        this.gcRoots = gcRoots;
        this.repository = repository;
        this.artifactIdentityDeterminer = artifactIdentityDeterminer;
        this.eventLogger = eventLogger;
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException>(){

            public boolean visit(GraphNode<InstallArtifact> graph) throws DeploymentException {
                PlanResolver.this.operate((InstallArtifact)graph.getValue());
                return true;
            }
        });
    }

    private void operate(InstallArtifact installArtifact) throws DeploymentException {
        PlanInstallArtifact planInstallArtifact;
        if (installArtifact instanceof PlanInstallArtifact && (planInstallArtifact = (PlanInstallArtifact)installArtifact).getGraph().getChildren().isEmpty()) {
            try {
                String scopeName = this.getArtifactScopeName(planInstallArtifact);
                GraphNode<InstallArtifact> graph = planInstallArtifact.getGraph();
                List<ArtifactSpecification> artifactSpecifications = planInstallArtifact.getArtifactSpecifications();
                for (ArtifactSpecification artifactSpecification : artifactSpecifications) {
                    GraphNode<InstallArtifact> childInstallNode = this.obtainInstallArtifactGraph(artifactSpecification, scopeName, planInstallArtifact.getProvisioning());
                    boolean newNode = childInstallNode.getParents().isEmpty() && !((AbstractInstallArtifact)childInstallNode.getValue()).getTopLevelDeployed();
                    graph.addChild(childInstallNode);
                    if (!newNode) continue;
                    InstallArtifact childInstallArtifact = (InstallArtifact)childInstallNode.getValue();
                    ((AbstractInstallArtifact)childInstallArtifact).beginInstall();
                }
            }
            catch (DeploymentException de) {
                throw new DeploymentException("Deployment of " + planInstallArtifact + " failed: " + de.getMessage(), (Throwable)de);
            }
        }
    }

    private String getArtifactScopeName(InstallArtifact installArtifact) {
        PlanInstallArtifact planInstallArtifact;
        boolean scoped;
        if (installArtifact instanceof PlanInstallArtifact && (scoped = (planInstallArtifact = (PlanInstallArtifact)installArtifact).isScoped())) {
            return String.valueOf(planInstallArtifact.getName()) + SCOPE_SEPARATOR + PlanResolver.versionToShortString(planInstallArtifact.getVersion());
        }
        return installArtifact.getScopeName();
    }

    private static String versionToShortString(Version version) {
        String result = version.toString();
        while (result.endsWith(".0")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private GraphNode<InstallArtifact> obtainInstallArtifactGraph(ArtifactSpecification artifactSpecification, String scopeName, PlanDescriptor.Provisioning parentProvisioning) throws DeploymentException {
        GraphNode<InstallArtifact> sharedNode = null;
        ArtifactIdentity identity = null;
        File artifact = null;
        Map<String, String> properties = this.determineDeploymentProperties(artifactSpecification.getProperties(), parentProvisioning);
        String repositoryName = null;
        URI uri = artifactSpecification.getUri();
        if (uri == null) {
            RepositoryAwareArtifactDescriptor repositoryAwareArtifactDescriptor = this.lookup(artifactSpecification);
            if (repositoryAwareArtifactDescriptor == null) {
                VersionRange versionRange;
                String name;
                String type = artifactSpecification.getType();
                sharedNode = this.findSharedNode(type, name = artifactSpecification.getName(), versionRange = artifactSpecification.getVersionRange(), null);
                if (sharedNode == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.ARTIFACT_NOT_FOUND, new Object[]{type, name, versionRange, this.repository.getName()});
                    throw new DeploymentException(String.valueOf(type) + " '" + name + "' in version range '" + versionRange + "' not found");
                }
            } else {
                URI artifactUri = repositoryAwareArtifactDescriptor.getUri();
                artifact = new File(artifactUri);
                identity = new ArtifactIdentity(repositoryAwareArtifactDescriptor.getType(), repositoryAwareArtifactDescriptor.getName(), repositoryAwareArtifactDescriptor.getVersion(), scopeName);
                repositoryName = repositoryAwareArtifactDescriptor.getRepositoryName();
                sharedNode = this.findSharedNode(identity);
            }
        } else {
            try {
                artifact = new File(uri);
            }
            catch (IllegalArgumentException e) {
                throw new DeploymentException("Invalid artifact specification URI '" + uri.toString() + "'", (Throwable)e);
            }
            identity = this.determineIdentity(uri, scopeName);
            sharedNode = this.findSharedNode(identity);
        }
        return sharedNode == null ? this.installArtifactGraphInclosure.constructGraphNode(identity, artifact, properties, repositoryName) : sharedNode;
    }

    private Map<String, String> determineDeploymentProperties(Map<String, String> properties, PlanDescriptor.Provisioning parentProvisioning) {
        HashMap<String, String> deploymentProperties = new HashMap<String, String>(properties);
        deploymentProperties.put(PROVISIONING_PROPERTY_NAME, parentProvisioning.toString());
        return deploymentProperties;
    }

    private RepositoryAwareArtifactDescriptor lookup(ArtifactSpecification specification) throws DeploymentException {
        String type = specification.getType();
        String name = specification.getName();
        VersionRange versionRange = specification.getVersionRange();
        return this.repository.get(type, name, versionRange);
    }

    private ArtifactIdentity determineIdentity(URI artifactUri, String scopeName) throws DeploymentException {
        try {
            File artifact = new File(artifactUri);
            if (!artifact.exists()) {
                throw new DeploymentException(artifact + " does not exist");
            }
            return this.determineIdentity(artifact, scopeName);
        }
        catch (Exception e) {
            throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + artifactUri + "'", (Throwable)e);
        }
    }

    private ArtifactIdentity determineIdentity(File file, String scopeName) throws DeploymentException {
        ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(file, scopeName);
        if (artifactIdentity == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.INDETERMINATE_ARTIFACT_TYPE, new Object[]{file});
            throw new DeploymentException("Cannot determine the artifact identity of the file '" + file + "'");
        }
        return artifactIdentity;
    }

    private GraphNode<InstallArtifact> findSharedNode(ArtifactIdentity artifactIdentity) {
        return ExistingNodeLocator.findSharedNode(this.gcRoots, artifactIdentity);
    }

    public GraphNode<InstallArtifact> findSharedNode(String type, String name, VersionRange versionRange, String scopeName) {
        return ExistingNodeLocator.findSharedNode(this.gcRoots, type, name, versionRange, scopeName);
    }
}

