/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.eclipse.virgo.snaps.Snap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class SnapsTag
extends BodyTagSupport {
    private static final long serialVersionUID = 4715961747733658692L;
    private static final String SNAP_SERVICE_CLASS = "org.eclipse.virgo.snaps.core.internal.Snap";
    public static final String SNAPS_ATTRIBUTE_NAME = "snaps";
    private volatile String attributeName = "snaps";

    public void setVar(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getVar() {
        return this.attributeName;
    }

    public int doStartTag() throws JspException {
        BundleContext bundleContext = (BundleContext)this.pageContext.getServletContext().getAttribute("osgi-bundlecontext");
        long hostId = bundleContext.getBundle().getBundleId();
        try {
            Object[] serviceReferences = bundleContext.getServiceReferences(SNAP_SERVICE_CLASS, "(snap.host.id=" + hostId + ")");
            ArrayList<Snap> snaps = new ArrayList<Snap>();
            if (serviceReferences != null) {
                Arrays.sort(serviceReferences);
                Object[] objectArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    Object serviceReference = objectArray[n2];
                    snaps.add(SnapsTag.createSnap(serviceReference));
                    ++n2;
                }
            }
            this.pageContext.setAttribute(this.attributeName, snaps);
        }
        catch (InvalidSyntaxException ise) {
            throw new JspException("Unexpected InvalidSyntaxException when querying service registry for Snaps", (Throwable)ise);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute(this.attributeName);
        return 6;
    }

    private static Snap createSnap(ServiceReference<?> serviceReference) {
        String[] propertyKeys = serviceReference.getPropertyKeys();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String[] stringArray = propertyKeys;
        int n = propertyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            attributes.put(key, serviceReference.getProperty(key));
            ++n2;
        }
        return new Snap(attributes);
    }
}

