/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDispatcherType;
import org.eclipse.virgo.snaps.core.internal.webapp.config.MutableWebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXmlParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class WebXmlParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ELEMENT_PARAM_VALUE = "param-value";
    private static final String ELEMENT_PARAM_NAME = "param-name";
    private static final String ELEMENT_INIT_PARAM = "init-param";
    private static final String ELEMENT_URL_PATTERN = "url-pattern";
    private static final String ELEMENT_SERVLET_MAPPING = "servlet-mapping";
    private static final String ELEMENT_SERVLET_CLASS = "servlet-class";
    private static final String ELEMENT_SERVLET_NAME = "servlet-name";
    private static final String ELEMENT_SERVLET = "servlet";
    private static final String ELEMENT_FILTER = "filter";
    private static final String ELEMENT_FILTER_CLASS = "filter-class";
    private static final String ELEMENT_FILTER_NAME = "filter-name";
    private static final String ELEMENT_FILTER_MAPPING = "filter-mapping";
    private static final String ELEMENT_DISPATCHER = "dispatcher";

    WebXmlParser() {
    }

    public void parse(InputStream resource, MutableWebXml webXml) {
        BufferedInputStream parseResource = new BufferedInputStream(resource);
        Document document = this.loadDocument(parseResource);
        this.parseServletDefinitions(document, webXml);
        this.parseServletMappingDefinitions(document, webXml);
        this.parseFilterDefinitions(document, webXml);
        this.parseFilterMappingDefinitions(document, webXml);
    }

    private void parseServletDefinitions(Document document, MutableWebXml webXml) {
        NodeList nodes = document.getElementsByTagName(ELEMENT_SERVLET);
        int x = 0;
        while (x < nodes.getLength()) {
            Node e = nodes.item(x);
            String servletName = this.extractChildNodeValue(e, ELEMENT_SERVLET_NAME);
            String servletClassName = this.extractChildNodeValue(e, ELEMENT_SERVLET_CLASS);
            MutableWebXml.MutableServletDefinition servletDefinition = webXml.addServletDefinition(servletName, servletClassName);
            this.parseInitParameters(e, servletDefinition);
            ++x;
        }
    }

    private void parseInitParameters(Node servletOrFilterNode, MutableWebXml.AbstractWebComponentDefinition definition) {
        NodeList childNodes = servletOrFilterNode.getChildNodes();
        int x = 0;
        while (x < childNodes.getLength()) {
            Node node = childNodes.item(x);
            if (ELEMENT_INIT_PARAM.equals(node.getNodeName())) {
                String paramName = this.extractChildNodeValue(node, ELEMENT_PARAM_NAME);
                String paramValue = this.extractChildNodeValue(node, ELEMENT_PARAM_VALUE);
                definition.addInitParameter(paramName, paramValue);
            }
            ++x;
        }
    }

    private void parseServletMappingDefinitions(Document document, MutableWebXml webXml) {
        NodeList nodes = document.getElementsByTagName(ELEMENT_SERVLET_MAPPING);
        int x = 0;
        while (x < nodes.getLength()) {
            Node e = nodes.item(x);
            String servletName = this.extractChildNodeValue(e, ELEMENT_SERVLET_NAME);
            String[] urlPatterns = this.extractChildNodesValues(e, ELEMENT_URL_PATTERN);
            if (urlPatterns.length == 0) {
                throw new WebXmlParseException("Missing 'url-pattern' under '" + e.getNodeName() + "' for servlet name '" + servletName + "'");
            }
            String[] stringArray = urlPatterns;
            int n = urlPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String urlPattern = stringArray[n2];
                webXml.addServletMappingDefinition(servletName, urlPattern);
                ++n2;
            }
            ++x;
        }
    }

    private void parseFilterDefinitions(Document document, MutableWebXml webXml) {
        NodeList nodes = document.getElementsByTagName(ELEMENT_FILTER);
        int x = 0;
        while (x < nodes.getLength()) {
            Node e = nodes.item(x);
            String filterName = this.extractChildNodeValue(e, ELEMENT_FILTER_NAME);
            String filterClassName = this.extractChildNodeValue(e, ELEMENT_FILTER_CLASS);
            MutableWebXml.MutableFilterDefinition filterDefinition = webXml.addFilterDefinition(filterName, filterClassName);
            this.parseInitParameters(e, filterDefinition);
            ++x;
        }
    }

    private void parseFilterMappingDefinitions(Document document, MutableWebXml webXml) {
        NodeList nodes = document.getElementsByTagName(ELEMENT_FILTER_MAPPING);
        int x = 0;
        while (x < nodes.getLength()) {
            Node e = nodes.item(x);
            String filterName = this.extractChildNodeValue(e, ELEMENT_FILTER_NAME);
            String[] servletNames = this.extractChildNodesValues(e, ELEMENT_SERVLET_NAME);
            String[] urlPatterns = this.extractChildNodesValues(e, ELEMENT_URL_PATTERN);
            Set<FilterDispatcherType> dispatcherTypes = this.getConfiguredDispatcherTypes(e);
            if (servletNames.length == 0 && urlPatterns.length == 0) {
                throw new WebXmlParseException("Missing 'servlet-name' or 'url-pattern' under '" + e.getNodeName() + "'");
            }
            String[] stringArray = servletNames;
            int n = servletNames.length;
            int n2 = 0;
            while (n2 < n) {
                String servletName = stringArray[n2];
                webXml.addServletNameFilterMappingDefinition(filterName, servletName, dispatcherTypes);
                ++n2;
            }
            stringArray = urlPatterns;
            n = urlPatterns.length;
            n2 = 0;
            while (n2 < n) {
                String urlPattern = stringArray[n2];
                webXml.addUrlPatternFilterMappingDefinition(filterName, urlPattern, dispatcherTypes);
                ++n2;
            }
            ++x;
        }
    }

    private Set<FilterDispatcherType> getConfiguredDispatcherTypes(Node e) {
        String[] values = this.extractChildNodesValues(e, ELEMENT_DISPATCHER);
        HashSet<FilterDispatcherType> dispatcherTypes = new HashSet<FilterDispatcherType>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String dispatcherType = stringArray[n2];
            dispatcherTypes.add(FilterDispatcherType.valueOf(dispatcherType));
            ++n2;
        }
        if (dispatcherTypes.isEmpty()) {
            dispatcherTypes.add(FilterDispatcherType.REQUEST);
        }
        return dispatcherTypes;
    }

    private String extractChildNodeValue(Node node, String childName) {
        NodeList childNodes = node.getChildNodes();
        int x = 0;
        while (x < childNodes.getLength()) {
            Node child = childNodes.item(x);
            if (childName.equals(child.getNodeName())) {
                return child.getTextContent().trim();
            }
            ++x;
        }
        throw new WebXmlParseException("Missing '" + childName + "' under '" + node.getNodeName() + "'");
    }

    private String[] extractChildNodesValues(Node node, String childName) {
        ArrayList<String> values = new ArrayList<String>();
        NodeList childNodes = node.getChildNodes();
        int x = 0;
        while (x < childNodes.getLength()) {
            Node child = childNodes.item(x);
            if (childName.equals(child.getNodeName())) {
                values.add(child.getTextContent().trim());
            }
            ++x;
        }
        return values.toArray(new String[values.size()]);
    }

    private Document loadDocument(InputStream resource) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().parse(resource);
        }
        catch (SAXException e) {
            this.logger.error("Error parsing web.xml file", (Throwable)e);
            throw new WebXmlParseException("Error parsing web.xml file.", e);
        }
        catch (IOException e) {
            this.logger.error("Unable to read web.xml file", (Throwable)e);
            throw new WebXmlParseException("Unable to read web.xml file.", e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create XML parser", (Throwable)e);
            throw new WebXmlParseException("Unable to create XML parser.", e);
        }
    }
}

