/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import java.util.Arrays;
import java.util.List;
import org.eclipse.virgo.medic.log.impl.logback.ContextSelectorDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingContextSelector
implements ContextSelector {
    private static volatile ContextSelectorDelegate delegate;
    private static volatile LoggerContext defaultLoggerContext;
    private static volatile boolean defaultContextConfigured;

    public DelegatingContextSelector(LoggerContext loggerContext) {
        DelegatingContextSelector.setDefaultLoggerContext(loggerContext);
    }

    private static void setDefaultLoggerContext(LoggerContext loggerContext) {
        if (delegate != null) {
            DelegatingContextSelector.configureDefaultContextIfNecessary(delegate, loggerContext);
        }
        defaultLoggerContext = loggerContext;
    }

    private static void configureDefaultContextIfNecessary(ContextSelectorDelegate delegate, LoggerContext defaultLoggerContext) {
        if (!defaultContextConfigured) {
            delegate.configureDefaultContext(defaultLoggerContext);
            defaultContextConfigured = true;
        }
    }

    public LoggerContext detachLoggerContext(String loggerContextName) {
        if (delegate == null) {
            return defaultLoggerContext;
        }
        return delegate.detachLoggerContext(loggerContextName);
    }

    public List<String> getContextNames() {
        if (delegate == null) {
            return Arrays.asList(defaultLoggerContext.getName());
        }
        return delegate.getContextNames();
    }

    public LoggerContext getDefaultLoggerContext() {
        return defaultLoggerContext;
    }

    public LoggerContext getLoggerContext() {
        if (delegate == null) {
            return defaultLoggerContext;
        }
        LoggerContext loggerContext = delegate.getLoggerContext();
        if (loggerContext != null) {
            return loggerContext;
        }
        return defaultLoggerContext;
    }

    public LoggerContext getLoggerContext(String name) {
        if (name.equals(defaultLoggerContext.getName())) {
            return defaultLoggerContext;
        }
        return delegate.getLoggerContext(name);
    }

    public static void setDelegate(ContextSelectorDelegate delegate) {
        if (delegate != null && defaultLoggerContext != null) {
            DelegatingContextSelector.configureDefaultContextIfNecessary(delegate, defaultLoggerContext);
        }
        DelegatingContextSelector.delegate = delegate;
    }
}

