/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshException;
import org.eclipse.virgo.kernel.install.artifact.internal.StartEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StartException;
import org.eclipse.virgo.kernel.install.artifact.internal.StopEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StopException;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLifecycleEngine
implements StartEngine,
RefreshEngine,
StopEngine {
    private final Logger logger;
    private final ConfigurationAdmin configurationAdmin;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public ConfigLifecycleEngine(ConfigurationAdmin configurationAdmin) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.configurationAdmin = configurationAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void start(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StartException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    this.updateConfiguration(artifactIdentity, artifactFS);
                }
                catch (IOException e) {
                    String message = String.format("Unable to start configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
                    this.logger.error(message);
                    throw new StartException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void refresh(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws RefreshException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    this.updateConfiguration(artifactIdentity, artifactFS);
                }
                catch (IOException e) {
                    String message = String.format("Unable to refresh configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
                    this.logger.error(message);
                    throw new RefreshException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateConfiguration(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws IOException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                InputStream inputStream = null;
                try {
                    inputStream = artifactFS.getEntry("").getInputStream();
                    Configuration configuration = this.getConfiguration(artifactIdentity);
                    configuration.update((Dictionary)this.getProperties(inputStream));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties getProperties(InputStream inputSteam) throws IOException {
        try {
            Properties p = new Properties();
            p.load(inputSteam);
            return p;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StopException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                try {
                    Configuration configuration = this.getConfiguration(artifactIdentity);
                    configuration.delete();
                }
                catch (IOException e) {
                    String message = String.format("Unable to stop configuration '%s'", artifactIdentity.getName());
                    this.logger.error(message);
                    throw new StopException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Configuration getConfiguration(ArtifactIdentity artifactIdentity) throws IOException {
        try {
            return this.configurationAdmin.getConfiguration(artifactIdentity.getName());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ConfigLifecycleEngine.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.StartException:", "void"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.RefreshException:", "void"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateConfiguration", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "java.io.IOException:", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.StopException:", "void"), 78);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine");
    }
}

