/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.Tree;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.web.core.internal.WebDeploymentEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebBundleTransformer
implements Transformer {
    private final Logger logger;
    private final WebDeploymentEnvironment environment;
    static final String WEB_BUNDLE_MODULE_TYPE = "web-bundle";
    static final String MANIFEST_HEADER_MODULE_TYPE = "Module-Type";
    private static final String WAR_EXTENSION = ".war";
    private static final String MANIFEST_HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    WebBundleTransformer(WebDeploymentEnvironment environment) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.environment = environment;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void transform(Tree<InstallArtifact> installTree, InstallEnvironment installEnvironment) throws DeploymentException {
        try {
            installTree.visit((Tree.ExceptionThrowingTreeVisitor)new Tree.ExceptionThrowingTreeVisitor<InstallArtifact, DeploymentException>(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                public boolean visit(Tree<InstallArtifact> tree) throws DeploymentException {
                    try {
                        InstallArtifact installArtifact = (InstallArtifact)tree.getValue();
                        if (WebBundleTransformer.access$0(WebBundleTransformer.this, installArtifact)) {
                            WebBundleTransformer.access$1(WebBundleTransformer.this, (BundleInstallArtifact)installArtifact);
                        }
                        return true;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebBundleTransformer$1");
                }
            });
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean checkWebBundle(InstallArtifact installArtifact) throws DeploymentException {
        try {
            if (installArtifact instanceof BundleInstallArtifact) {
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                if (this.hasWebContextPath(bundleInstallArtifact)) {
                    return true;
                }
                if (this.hasWarSuffix(installArtifact)) {
                    this.setDefaultWebContextPath(bundleInstallArtifact);
                    return true;
                }
            }
            return false;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean hasWarSuffix(InstallArtifact installArtifact) {
        try {
            return installArtifact.getArtifactFS().getFile().getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean hasWebContextPath(BundleInstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                return installArtifact.getBundleManifest().getHeader(MANIFEST_HEADER_WEB_CONTEXT_PATH) != null;
            }
            catch (IOException ioe) {
                throw new DeploymentException("Could not retrieve manifest for bundle install artifact " + installArtifact, (Throwable)ioe);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void setDefaultWebContextPath(BundleInstallArtifact bundleInstallArtifact) throws DeploymentException {
        try {
            String webContextPath = WebBundleTransformer.getBaseName(bundleInstallArtifact.getArtifactFS().getFile().getPath());
            try {
                bundleInstallArtifact.getBundleManifest().setHeader(MANIFEST_HEADER_WEB_CONTEXT_PATH, webContextPath);
            }
            catch (IOException ioe) {
                throw new DeploymentException("Could not retrieve manifest for bundle install artifact " + bundleInstallArtifact, (Throwable)ioe);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String getBaseName(String path) {
        try {
            String base = path;
            base = WebBundleTransformer.unifySeparators(base);
            if (base.endsWith("/")) {
                base = base.substring(0, base.length() - 1);
            }
            base = WebBundleTransformer.stripQuery(base);
            base = WebBundleTransformer.stripSchemeAndDrive(base);
            base = WebBundleTransformer.stripLeadingPathElements(base);
            base = WebBundleTransformer.stripExtension(base);
            return base;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String unifySeparators(String base) {
        try {
            return base.replaceAll("\\\\", "/");
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String stripExtension(String base) {
        try {
            int index = base.lastIndexOf(".");
            if (index > -1) {
                base = base.substring(0, index);
            }
            return base;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String stripLeadingPathElements(String base) {
        try {
            int index = base.lastIndexOf("/");
            if (index > -1) {
                base = base.substring(index + 1);
            }
            return base;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String stripQuery(String path) {
        try {
            String result = path;
            int index = result.lastIndexOf("?");
            if (index > -1) {
                result = result.substring(0, index);
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String stripSchemeAndDrive(String path) {
        try {
            String result = path;
            int index = result.indexOf(":");
            while (index > -1 && index < result.length()) {
                result = result.substring(index + 1);
                index = result.indexOf(":");
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void applyWebContainerTransformations(BundleInstallArtifact bundleArtifact) throws DeploymentException {
        try {
            try {
                BundleManifest bundleManifest = bundleArtifact.getBundleManifest();
                if (bundleManifest.getModuleType() == null || "web".equalsIgnoreCase(bundleManifest.getModuleType())) {
                    bundleManifest.setHeader("SpringSource-DefaultWABHeaders", "true");
                    bundleManifest.setModuleType(WEB_BUNDLE_MODULE_TYPE);
                    boolean webBundle = WebBundleTransformer.isWebApplicationBundle(bundleManifest);
                    InstallationOptions installationOptions = new InstallationOptions(Collections.emptyMap());
                    installationOptions.setDefaultWABHeaders(true);
                    this.environment.getManifestTransformer().transform(bundleManifest, WebBundleTransformer.getSourceUrl((InstallArtifact)bundleArtifact), installationOptions, webBundle);
                } else {
                    this.logger.debug("Bundle '{}' version '{}' is not being transformed as it already has a Module-Type of '{}'", new Object[]{bundleManifest.getBundleSymbolicName().getSymbolicName(), bundleManifest.getBundleVersion(), bundleManifest.getModuleType()});
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Failed to apply web container transformations to bundle '" + bundleArtifact.getName() + "' version '" + bundleArtifact.getVersion() + "'", (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static URL getSourceUrl(InstallArtifact installArtifact) throws DeploymentException {
        try {
            URI sourceUri = installArtifact.getArtifactFS().getFile().toURI();
            if (sourceUri != null) {
                try {
                    return sourceUri.toURL();
                }
                catch (MalformedURLException murle) {
                    throw new DeploymentException("Install artifact '" + installArtifact + "' has source URI that is not a valid URL", (Throwable)murle);
                }
            }
            throw new DeploymentException("Install artifact '" + installArtifact + "' has a null source URI");
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static boolean isWebApplicationBundle(BundleManifest manifest) {
        try {
            return WebBundleTransformer.specifiesBundleSymbolicName(manifest) || WebBundleTransformer.specifiesBundleVersion(manifest) || WebBundleTransformer.specifiesBundleManifestVersion(manifest) || WebBundleTransformer.specifiesImportPackage(manifest) || WebBundleTransformer.specifiesWebContextPath(manifest);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleSymbolicName(BundleManifest manifest) {
        try {
            return manifest.getBundleSymbolicName().getSymbolicName() != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleVersion(BundleManifest manifest) {
        try {
            return manifest.getHeader("Bundle-Version") != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleManifestVersion(BundleManifest manifest) {
        try {
            return manifest.getBundleManifestVersion() != 1;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesImportPackage(BundleManifest manifest) {
        try {
            return !manifest.getImportPackage().getImportedPackages().isEmpty();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesWebContextPath(BundleManifest manifest) {
        try {
            return manifest.getHeader(MANIFEST_HEADER_WEB_CONTEXT_PATH) != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ boolean access$0(WebBundleTransformer arg0, InstallArtifact arg1) throws DeploymentException {
        try {
            return arg0.checkWebBundle(arg1);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$1(WebBundleTransformer arg0, BundleInstallArtifact arg1) throws DeploymentException {
        try {
            arg0.applyWebContainerTransformations(arg1);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebBundleTransformer");
    }
}

