/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.res;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private Locale locale;
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        this(packageName, Locale.getDefault());
    }

    private StringManager(String packageName, Locale loc) {
        String bundleName = packageName + ".LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName, loc);
        this.locale = this.bundle.getLocale();
    }

    private StringManager(ResourceBundle bundle) {
        this.bundle = bundle;
        this.locale = bundle.getLocale();
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        String str = null;
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public String getString(String key, Object ... args) {
        String value = this.getString(key);
        if (value == null) {
            value = key;
        }
        MessageFormat mf = new MessageFormat(value);
        mf.setLocale(this.locale);
        return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(ResourceBundle bundle) {
        return new StringManager(bundle);
    }

    public static synchronized StringManager getManager(String packageName, Locale loc) {
        StringManager mgr = (StringManager)managers.get(packageName + "_" + loc.toString());
        if (mgr == null) {
            mgr = new StringManager(packageName, loc);
            managers.put(packageName + "_" + loc.toString(), mgr);
        }
        return mgr;
    }
}

