/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.manifest;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;
import org.eclipse.virgo.util.parser.manifest.ManifestParser;
import org.eclipse.virgo.util.parser.manifest.ManifestProblem;
import org.eclipse.virgo.util.parser.manifest.ManifestProblemKind;
import org.eclipse.virgo.util.parser.manifest.internal.ManifestVisitor;
import org.eclipse.virgo.util.parser.manifest.internal.RecoveringManifestLexer;
import org.eclipse.virgo.util.parser.manifest.internal.StandardVisitor;
import org.eclipse.virgo.util.parser.manifest.internal.Token;
import org.eclipse.virgo.util.parser.manifest.internal.TokenKind;
import org.eclipse.virgo.util.parser.manifest.internal.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveringManifestParser
implements ManifestParser {
    private static final String NAME_HEADER = "Name";
    ManifestVisitor visitor;
    TokenStream tokenStream;

    public RecoveringManifestParser() {
        this.visitor = new StandardVisitor();
    }

    public RecoveringManifestParser(ManifestVisitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public ManifestContents parse(String manifestString) {
        this.tokenStream = RecoveringManifestLexer.tokenize(manifestString);
        return this.parseManifest();
    }

    @Override
    public ManifestContents parse(Reader reader) throws IOException {
        this.tokenStream = RecoveringManifestLexer.tokenize(reader);
        return this.parseManifest();
    }

    ManifestContents parseManifest() {
        this.checkForRogueNewlinesProceedingInput();
        boolean cont = this.eatSection(true);
        while (this.tokenStream.hasMore() && cont) {
            cont = this.eatSection(false);
        }
        if (cont) {
            this.confirmEnd();
        }
        return this.visitor.getManifestContents();
    }

    public ManifestContents getManifestContents() {
        return this.visitor.getManifestContents();
    }

    private void confirmEnd() {
    }

    private void checkForRogueNewlinesProceedingInput() {
        while (this.maybeEatNewline()) {
        }
    }

    public void eatNewline() {
        assert (this.tokenStream.hasMore());
        Token t = this.tokenStream.next();
        assert (t.getKind() == TokenKind.NEWLINE);
    }

    public boolean eatSection(boolean isMain) {
        boolean cont = true;
        if (isMain) {
            this.visitor.visitSection(true, null);
        } else {
            while (this.maybeEatNewline()) {
            }
            if (this.tokenStream.hasMore()) {
                cont = this.eatNameAttribute();
            }
        }
        while (!this.maybeEatNewline() && this.tokenStream.hasMore() && cont) {
            this.eatAttribute(isMain);
        }
        return cont;
    }

    public void eatVersionInfo() {
        if (this.maybeEatHeaderName("Manifest-Version")) {
            this.eatColon();
            this.eatVersionNumber();
            this.eatNewline();
        }
    }

    private boolean maybeEatHeaderName(String expectedName) {
        Token t = this.tokenStream.peek();
        if (TokenKind.isName(t)) {
            if (t.value().equals(expectedName)) {
                this.tokenStream.next();
                return true;
            }
            this.recordProblem(ManifestProblemKind.UNEXPECTED_NAME, t.getStartOffset(), t.getEndOffset(), expectedName, t.value());
            return false;
        }
        this.recordProblem(ManifestProblemKind.UNEXPECTED_TOKEN_KIND, t.getStartOffset(), t.getEndOffset(), NAME_HEADER, t.getKind().getTokenString());
        return false;
    }

    public void eatColon() {
        Token t = this.tokenStream.next();
        assert (t.getKind() == TokenKind.COLON);
    }

    public void eatAttribute(boolean isMain) {
        Token nameToken = this.tokenStream.next();
        this.tokenStream.next();
        Token valueToken = this.tokenStream.next();
        this.tokenStream.next();
        this.visitor.visitHeader(nameToken.value(), valueToken.value());
    }

    public void eatVersionNumber() {
        Token tok = this.tokenStream.next();
        assert (tok.getKind() == TokenKind.VALUE);
        this.visitor.visitManifestVersion(tok.value());
    }

    private boolean maybeEatNewline() {
        if (this.tokenStream.hasMore()) {
            Token t = this.tokenStream.peek();
            if (TokenKind.isNewline(t)) {
                this.tokenStream.next();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean eatNameAttribute() {
        boolean cont;
        if (this.maybeEatHeaderName(NAME_HEADER)) {
            this.eatColon();
            Token valueToken = this.tokenStream.next();
            this.tokenStream.next();
            cont = this.visitor.visitSection(false, valueToken.value());
            if (!cont) {
                return false;
            }
            this.visitor.visitHeader(NAME_HEADER, valueToken.value());
        } else {
            Token token = this.tokenStream.peek();
            cont = this.visitor.visitSection(false, null);
            this.recordProblem(ManifestProblemKind.MISSING_NAME_HEADER, token.getStartOffset(), token.getEndOffset(), token.value());
        }
        return cont;
    }

    @Override
    public boolean foundProblems() {
        return this.tokenStream.containsProblems();
    }

    @Override
    public List<ManifestProblem> getProblems() {
        return this.tokenStream.getProblems();
    }

    private void recordProblem(ManifestProblemKind parseProblem, int startOffset, int endOffset, String ... inserts) {
        this.tokenStream.recordProblem(new ManifestProblem(parseProblem, this.tokenStream.getSourceContext(), startOffset, endOffset, inserts));
    }

    @Override
    public void setTerminateAfterMainSection(boolean shouldTerminate) {
        this.visitor.setTerminateAfterMainSection(shouldTerminate);
    }
}

