/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansConfigurationHttpSessionListener
implements HttpSessionListener {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansConfigurationHttpSessionListener.class);
    protected ContainerLifecycle lifeCycle = (ContainerLifecycle)WebBeansContext.getInstance().getService(ContainerLifecycle.class);

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        ConversationManager conversationManager = WebBeansContext.getInstance().getConversationManager();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }
}

