/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CaseInsensitiveMap<V>
extends AbstractMap<String, V> {
    private final Map<CaseInsensitiveKey, V> map = new ConcurrentHashMap<CaseInsensitiveKey, V>();

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(CaseInsensitiveMap<? extends V> map) {
        this.map.putAll(map.map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String ? this.map.containsKey(CaseInsensitiveKey.objectToKey(key)) : false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet<V>(this.map.entrySet(), this);
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? (V)this.map.get(CaseInsensitiveKey.objectToKey(key)) : null;
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.map.keySet());
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new NullPointerException("CaseInsensitiveMap does not permit null keys");
        }
        return this.map.put(CaseInsensitiveKey.objectToKey(key), value);
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? (V)this.map.remove(CaseInsensitiveKey.objectToKey(key)) : null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    static final class CaseInsensitiveKey {
        private final String key;

        private CaseInsensitiveKey(String key) {
            this.key = key;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.key.toLowerCase().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CaseInsensitiveKey other = (CaseInsensitiveKey)obj;
            return !(this.key == null ? other.key != null : !this.key.equalsIgnoreCase(other.key));
        }

        public String toString() {
            return this.key;
        }

        public static CaseInsensitiveKey objectToKey(Object key) {
            return new CaseInsensitiveKey((String)key);
        }
    }

    private static final class EntrySet<V>
    extends AbstractSet<Map.Entry<String, V>> {
        private final Set<Map.Entry<CaseInsensitiveKey, V>> entrySet;
        private final CaseInsensitiveMap<V> map;

        public EntrySet(Set<Map.Entry<CaseInsensitiveKey, V>> entrySet, CaseInsensitiveMap<V> map) {
            this.entrySet = entrySet;
            this.map = map;
        }

        @Override
        public boolean add(Map.Entry<String, V> o) {
            throw new UnsupportedOperationException("Map.entrySet must return a Set which does not support add");
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
            throw new UnsupportedOperationException("Map.entrySet must return a Set which does not support addAll");
        }

        @Override
        public void clear() {
            this.entrySet.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                V value = this.map.get(e.getKey());
                return value.equals(e.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntrySetIterator<V>(this.entrySet.iterator());
        }

        @Override
        public boolean remove(Object o) {
            try {
                return this.entrySet.remove(((MapEntry)o).getEntry());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        private static final class EntrySetIterator<V>
        implements Iterator<Map.Entry<String, V>> {
            private final Iterator<Map.Entry<CaseInsensitiveKey, V>> iterator;

            public EntrySetIterator(Iterator<Map.Entry<CaseInsensitiveKey, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, V> next() {
                return new MapEntry<V>(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }

        private static final class MapEntry<V>
        implements Map.Entry<String, V> {
            private final Map.Entry<CaseInsensitiveKey, V> entry;

            public MapEntry(Map.Entry<CaseInsensitiveKey, V> entry) {
                this.entry = entry;
            }

            @Override
            public String getKey() {
                return this.entry.getKey().toString();
            }

            @Override
            public V getValue() {
                return this.entry.getValue();
            }

            @Override
            public V setValue(V value) {
                return this.entry.setValue(value);
            }

            public Map.Entry<CaseInsensitiveKey, V> getEntry() {
                return this.entry;
            }
        }
    }

    private static final class KeySet
    extends AbstractSet<String> {
        private final Set<CaseInsensitiveKey> keySet;

        public KeySet(Set<CaseInsensitiveKey> keySet) {
            this.keySet = keySet;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException("Map.keySet must return a Set which does not support add");
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException("Map.keySet must return a Set which does not support addAll");
        }

        @Override
        public void clear() {
            this.keySet.clear();
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof String ? this.keySet.contains(CaseInsensitiveKey.objectToKey(o)) : false;
        }

        @Override
        public Iterator<String> iterator() {
            return new KeySetIterator(this.keySet.iterator());
        }

        @Override
        public boolean remove(Object o) {
            return this.keySet.remove(CaseInsensitiveKey.objectToKey(o));
        }

        @Override
        public int size() {
            return this.keySet.size();
        }

        private static final class KeySetIterator
        implements Iterator<String> {
            private Iterator<CaseInsensitiveKey> iterator;

            public KeySetIterator(Iterator<CaseInsensitiveKey> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return this.iterator.next().toString();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

