/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;

public class CacheId
implements Serializable,
Comparable<CacheId> {
    protected Object[] primaryKey;
    protected int hash;

    public CacheId(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public Object[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public void add(Object value) {
        Object[] array = new Object[this.primaryKey.length + 1];
        System.arraycopy(this.primaryKey, 0, array, 0, this.primaryKey.length);
        array[this.primaryKey.length] = value;
        this.setPrimaryKey(array);
    }

    public void set(int index, Object value) {
        this.primaryKey[index] = value;
        this.setPrimaryKey(this.primaryKey);
    }

    protected int computeHash(Object[] primaryKey) {
        int hashValue = 0;
        Object[] objectArray = primaryKey;
        int n = primaryKey.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value != null) {
                hashValue = value.getClass().isArray() ? (hashValue ^= this.computeArrayHashCode(value)) : (hashValue ^= value.hashCode());
            }
            ++n2;
        }
        return hashValue;
    }

    private int computeArrayHashCode(Object obj) {
        if (obj.getClass() == ClassConstants.APBYTE) {
            return Arrays.hashCode((byte[])obj);
        }
        if (obj.getClass() == ClassConstants.APCHAR) {
            return Arrays.hashCode((char[])obj);
        }
        return Arrays.hashCode((Object[])obj);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheId)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(CacheId id) {
        if (this == id) {
            return true;
        }
        if (this.hash != id.hash) {
            return false;
        }
        int size = this.primaryKey.length;
        Object[] otherKey = id.primaryKey;
        if (size == otherKey.length) {
            int index = 0;
            while (index < size) {
                Object value = this.primaryKey[index];
                Object otherValue = otherKey[index];
                if (value == null) {
                    if (otherValue != null) {
                        return false;
                    }
                } else {
                    if (otherValue == null) {
                        return false;
                    }
                    Class<?> valueClass = value.getClass();
                    Class<?> otherClass = otherValue.getClass();
                    if (valueClass.isArray() ? (valueClass == ClassConstants.APBYTE && otherClass == ClassConstants.APBYTE ? !Helper.compareByteArrays((byte[])value, (byte[])otherValue) : (valueClass == ClassConstants.APCHAR && otherClass == ClassConstants.APCHAR ? !Helper.compareCharArrays((char[])value, (char[])otherValue) : !Helper.compareArrays((Object[])value, (Object[])otherValue))) : !value.equals(otherValue)) {
                        return false;
                    }
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CacheId id) {
        if (this == id) {
            return 0;
        }
        int size = this.primaryKey.length;
        Object[] otherKey = id.primaryKey;
        if (size == otherKey.length) {
            int index = 0;
            while (index < size) {
                Object value = this.primaryKey[index];
                Object otherValue = otherKey[index];
                if (value == null) {
                    if (otherValue != null) {
                        return -1;
                    }
                } else {
                    if (otherValue == null) {
                        return 1;
                    }
                    try {
                        int compareTo = ((Comparable)value).compareTo(otherValue);
                        if (compareTo != 0) {
                            return compareTo;
                        }
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
                ++index;
            }
            return 0;
        }
        if (size > otherKey.length) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "[" + Arrays.asList(this.primaryKey) + ": " + this.hash + "]";
    }
}

