/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.region.StandardRegionFilter;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

final class StandardRegionFilterBuilder
implements RegionFilterBuilder {
    private static final String ALL_SPEC = "(|(!(all=*))(all=*))";
    private static final Filter ALL;
    private final Object monitor = new Object();
    private final Map<String, Collection<Filter>> policy = new HashMap<String, Collection<Filter>>();

    static {
        try {
            ALL = FrameworkUtil.createFilter((String)ALL_SPEC);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    StandardRegionFilterBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilterBuilder allow(String namespace, String filter) throws InvalidSyntaxException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace must not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The filter must not be null.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Collection<Filter> namespaceFilters = this.policy.get(namespace);
            if (namespaceFilters == null) {
                namespaceFilters = new ArrayList<Filter>();
                this.policy.put(namespace, namespaceFilters);
            }
            namespaceFilters.add(FrameworkUtil.createFilter((String)filter));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilterBuilder allowAll(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace must not be null.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Collection<Filter> namespaceFilters = this.policy.get(namespace);
            if (namespaceFilters == null) {
                namespaceFilters = new ArrayList<Filter>();
                this.policy.put(namespace, namespaceFilters);
            }
            namespaceFilters.clear();
            namespaceFilters.add(ALL);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilter build() {
        Object object = this.monitor;
        synchronized (object) {
            return new StandardRegionFilter(this.policy);
        }
    }
}

