/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.core.BundleUtils;
import org.eclipse.virgo.nano.core.internal.SpringUtils;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleStartTracker
implements EventHandler {
    private static final String TOPIC_BLUEPRINT_EVENTS = "org/osgi/service/blueprint/container/";
    private static final String EVENT_REGION_STARTING = "org/eclipse/virgo/kernel/region/STARTING";
    private static final String EVENT_CREATED = "org/osgi/service/blueprint/container/CREATED";
    private static final String EVENT_FAILURE = "org/osgi/service/blueprint/container/FAILURE";
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleStartTracker.class);
    private final Object monitor;
    private final List<Bundle> bundlesWithCreatedApplicationContexts;
    private final Map<Bundle, Throwable> failureMap;
    private final Map<Bundle, List<AbortableSignal>> signalMap;
    private final BundleListener bundleListener;
    private final ExecutorService signalExecutor;

    BundleStartTracker(ExecutorService signalExecutor) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.bundlesWithCreatedApplicationContexts = new ArrayList<Bundle>();
            this.failureMap = new HashMap<Bundle, Throwable>();
            this.signalMap = new HashMap<Bundle, List<AbortableSignal>>();
            this.bundleListener = new StartupTrackerBundleListener(this, null);
            this.signalExecutor = signalExecutor;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void initialize(BundleContext bundleContext) {
        try {
            bundleContext.addBundleListener(this.bundleListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordApplicationContextCreation(Bundle bundle) {
        try {
            LOGGER.info("Recording created application context for bundle '{}'", (Object)bundle);
            Object object = this.monitor;
            synchronized (object) {
                this.bundlesWithCreatedApplicationContexts.add(bundle);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveSignalsIfStartCompleted(Bundle bundle, boolean springDmPowered) {
        try {
            List<AbortableSignal> signals = null;
            Throwable failure = null;
            boolean isActive = BundleStartTracker.isBundleActive(bundle);
            Object object = this.monitor;
            synchronized (object) {
                if (springDmPowered) {
                    boolean created = this.bundlesWithCreatedApplicationContexts.contains(bundle);
                    failure = this.failureMap.get(bundle);
                    if (created && failure != null) {
                        throw new IllegalStateException("Spring DM has notified an application context both successfully constructed and failed: " + failure);
                    }
                    if (created) {
                        LOGGER.info("Bundle '{}' has started and its application context is available", (Object)bundle);
                        signals = this.signalMap.remove(bundle);
                    } else if (failure != null) {
                        LOGGER.info("Bundle '{}' failed to start, the failure was '{}'", (Object)bundle, (Object)failure);
                        signals = this.signalMap.remove(bundle);
                    }
                } else if (isActive) {
                    signals = this.signalMap.remove(bundle);
                }
            }
            if (signals != null) {
                if (!springDmPowered && isActive) {
                    LOGGER.info("Non-Spring DM powered bundle '{}' has started. Driving signals '{}'.", (Object)bundle, signals);
                    this.driveSignals(signals, false, null);
                } else {
                    this.driveSignals(signals, false, failure);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void driveSignals(final List<AbortableSignal> signals, final boolean aborted, final Throwable cause) {
        try {
            this.signalExecutor.execute(new Runnable(){
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                @Override
                public void run() {
                    try {
                        for (AbortableSignal signal : signals) {
                            BundleStartTracker.access$3().info("Driving signal '{}'", (Object)signal);
                            if (aborted) {
                                signal.signalAborted();
                                continue;
                            }
                            if (cause == null) {
                                signal.signalSuccessfulCompletion();
                                continue;
                            }
                            signal.signalFailure(cause);
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }
            });
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        try {
            LOGGER.info("Handling event '{}'", (Object)event);
            Throwable cause = null;
            List<AbortableSignal> signals = null;
            Bundle bundle = (Bundle)event.getProperty("bundle");
            if (EVENT_FAILURE.equals(event.getTopic())) {
                cause = (Throwable)event.getProperty("exception");
                if (cause != null) {
                    Object object = this.monitor;
                    synchronized (object) {
                        LOGGER.error("Recording application context construction failure '{}' for bundle '{}'", (Object)cause, (Object)bundle);
                        this.failureMap.put(bundle, cause);
                        signals = this.signalMap.remove(bundle);
                    }
                }
            } else if (EVENT_CREATED.equals(event.getTopic())) {
                Object object = this.monitor;
                synchronized (object) {
                    this.recordApplicationContextCreation(bundle);
                    signals = this.signalMap.remove(bundle);
                }
            } else if (EVENT_REGION_STARTING.equals(event.getTopic())) {
                this.initialize((BundleContext)event.getProperty("region.bundleContext"));
            }
            if (signals != null) {
                this.driveSignals(signals, false, cause);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStart(Bundle bundle, AbortableSignal signal) {
        try {
            if (BundleUtils.isFragmentBundle(bundle)) {
                throw new IllegalArgumentException("Cannot track the start of a fragment bundle.");
            }
            boolean springDmPowered = BundleStartTracker.isSpringDmPoweredBundle(bundle);
            boolean bundleActive = BundleStartTracker.isBundleActive(bundle);
            if (signal != null) {
                if (springDmPowered || !bundleActive) {
                    Object object = this.monitor;
                    synchronized (object) {
                        List<AbortableSignal> queue = this.signalMap.get(bundle);
                        if (queue == null) {
                            queue = new ArrayList<AbortableSignal>();
                            this.signalMap.put(bundle, queue);
                        }
                        LOGGER.info("Adding signal '{}' for bundle '{}'", (Object)signal, (Object)bundle);
                        queue.add(signal);
                    }
                } else {
                    this.driveSignals(Arrays.asList(signal), false, null);
                }
            }
            this.driveSignalsIfStartCompleted(bundle, springDmPowered);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isBundleActive(Bundle bundle) {
        try {
            if (bundle != null) {
                return bundle.getState() == 32;
            }
            return false;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isSpringDmPoweredBundle(Bundle bundle) {
        try {
            return SpringUtils.isSpringDMPoweredBundle(bundle);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Bundle bundle, boolean aborted, Throwable cause) {
        try {
            List<AbortableSignal> danglingSignals = null;
            Object object = this.monitor;
            synchronized (object) {
                if (bundle != null) {
                    this.bundlesWithCreatedApplicationContexts.remove(bundle);
                    this.failureMap.remove(bundle);
                    danglingSignals = this.signalMap.remove(bundle);
                }
            }
            if (danglingSignals != null) {
                this.driveSignals(danglingSignals, aborted, cause);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop() {
        try {
            this.signalExecutor.shutdownNow();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ boolean access$0(Bundle arg0) {
        try {
            return BundleStartTracker.isSpringDmPoweredBundle(arg0);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Object access$1(BundleStartTracker arg0) {
        try {
            return arg0.monitor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Map access$2(BundleStartTracker arg0) {
        try {
            return arg0.signalMap;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Logger access$3() {
        try {
            return LOGGER;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$4(BundleStartTracker arg0, List arg1, boolean arg2, Throwable arg3) {
        try {
            arg0.driveSignals(arg1, arg2, arg3);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private final class StartupTrackerBundleListener
    implements SynchronousBundleListener {
        private Boolean isLazyBundle;
        final /* synthetic */ BundleStartTracker this$0;

        private StartupTrackerBundleListener(BundleStartTracker bundleStartTracker) {
            this.this$0 = bundleStartTracker;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.isLazyBundle = false;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            try {
                Bundle bundle = event.getBundle();
                if (event.getType() == 2) {
                    List signals = null;
                    if (!BundleStartTracker.access$0(bundle)) {
                        Object object = BundleStartTracker.access$1(this.this$0);
                        synchronized (object) {
                            signals = (List)BundleStartTracker.access$2(this.this$0).remove(bundle);
                        }
                        if (signals != null) {
                            BundleStartTracker.access$3().info("Non-Spring DM powered bundle '{}' has started. Driving signals '{}'.", (Object)bundle, (Object)signals);
                            BundleStartTracker.access$4(this.this$0, signals, false, null);
                        }
                    }
                }
                if (event.getType() == 512) {
                    this.isLazyBundle = true;
                    BundleStartTracker.access$3().info("Bundle '{}' has lazy activation and is in the starting state.", (Object)bundle);
                }
                if (event.getType() == 4) {
                    BundleStartTracker.access$3().info("Bundle '{}' has stopped. Removing its related tracking state.", (Object)bundle);
                    this.this$0.cleanup(bundle, this.isLazyBundle, this.isLazyBundle != false ? null : new RuntimeException("Bundle '" + bundle + "' stopped"));
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ StartupTrackerBundleListener(BundleStartTracker bundleStartTracker, StartupTrackerBundleListener startupTrackerBundleListener) {
            BundleStartTracker bundleStartTracker2 = bundleStartTracker;
            StartupTrackerBundleListener ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = bundleStartTracker2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.isLazyBundle = false;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

