/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.util.List;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.ResourceFinder;

public final class EventHelper {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, EventHelper.class);

    private EventHelper() {
    }

    public static void installExtensions(ResourceFinder finder) {
        try {
            List classes = finder.findAvailableClasses("org.apache.openejb.extension");
            for (Class clazz : classes) {
                try {
                    Object object = clazz.newInstance();
                    SystemInstance.get().addObserver(object);
                }
                catch (Throwable t) {
                    LOGGER.error("Extension construction failed" + clazz.getName(), t);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
        }
    }
}

